<?php
    class PrecoModel extends Database {

		protected function insertPreco($idTipoMatricula, $preco, $nota){
            $stmt = $this->connect();
            $sql = "INSERT INTO preco (idTipoMatricula, preco, nota) VALUES (?, ?, ?)";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($idTipoMatricula, $preco, $nota)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		public function listagemPreco(){
			$data = null;
			$sql = "SELECT * FROM viewprecotipomatricula";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryPreco($tipoMatricula){
			$data = null;
			$sql = "SELECT * FROM viewprecotipomatricula WHERE tipoMatricula = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$tipoMatricula]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function queryPrecoId($idPreco){
			$data = null;
			$sql = "SELECT * FROM viewprecotipomatricula WHERE idPreco = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idPreco]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		protected function editPreco($idPreco, $idTipoMatricula, $preco, $nota){
			$stmt = $this->connect();
			
            $sql = "UPDATE preco SET idTipoMatricula = ?, preco = ?, nota = ? WHERE idPreco = ?";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($idTipoMatricula, $preco, $nota, $idPreco)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		public function deletePreco($idPreco){
			$stmt = $this->connect();
            $sql = "DELETE FROM preco WHERE idPreco = ?";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($idPreco)))){
				$query = null;
				exit();
			}
		}
    }