<?php $page = 'familia';
include('header.php'); ?>

<body class="hold-transition layout-top-nav">
  <div class="wrapper">
    <div class="preloader flex-column justify-content-center align-items-center">
    </div>
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
      <!-- Content Header (Page header) -->
      <div class="content-header">
        <div class="container-fluid">
        </div><!-- /.container-fluid -->
      </div>
      <!-- /.content-header -->

      <section class="content">
        <div class="container-fluid">
          <div class="row">
            <!-- SELECT2 EXAMPLE -->
            <div class="col-md-12">
              <div class="card card-default">
                <div class="card-header">
                  <h3 class="card-title">Configurações Banco</h3>

                  <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                      <i class="fas fa-minus"></i>
                    </button>
                    <button type="button" class="btn btn-tool" data-card-widget="remove">
                      <i class="fas fa-times"></i>
                    </button>
                  </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                  <div class="row">
                    <div class="col-md-3">
                      <div class="form-group" style="margin-bottom: 0;">
                        <small>Botão</small>
                        <button class="btn btn-block btn-outline-success" id="btn-add" name="btn-submit"><i class="fas fa-plus"></i> Adicionar Linha</button>
                      </div>
                    </div>
                  </div>
                  <div class="row" id="formularioBanco">
                  </div>
                  <div class="col-md-12" style="padding: 0;">
                    <div class="form-group" style="margin-bottom: 0;">
                      <button class="btn btn-block btn-primary" id="btn-submit" name="btn-submit">Gravar Alterações</button>
                    </div>
                  </div>
                </div>
                <!-- /.row -->
              </div>
            </div>
          </div>
        </div>
        <!-- /.card -->
    </div>
    <!-- /.container-fluid -->
    </section>
  </div>
  <!-- /.content-wrapper -->
  <?php include('footer.php'); ?>
</body>

</html>
<script>
  function addRow(parametro) {
    const container = `<div class="linhaFormularioBanco" style="display: contents;">
    <div class="col-md-3">
                      <div class="form-group" style="margin-bottom: 0;">
                        <small class="required">Nome do Banco</small>
                        <input type="text" class="form-control" id="nomeBanco" name="nomeBanco" placeholder="Nome do Banco" title="Nome do Banco" value="${parametro !== null ? parametro.nomeBanco : ""}" required>
                        <small>Mensagem de erro</small>
                      </div>
                    </div>
                    <div class="col-md-4">
                      <div class="form-group" style="margin-bottom: 0;">
                        <small class="required">Número da Conta</small>
                        <input type="text" class="form-control" id="numeroConta" name="numeroConta" placeholder="Número da Conta" title="Número da Conta" value="${parametro !== null ? parametro.numeroConta : ""}" required>
                        <small>Mensagem de erro</small>
                      </div>
                    </div>
                    <div class="col-md-5">
                      <div class="row">
                      <div class="col-md-10">
                        <div class="form-group" style="margin-bottom: 0;">
                          <small class="required">IBAN (Número internacional de conta bancária)</small>
                          <input type="text" class="form-control" id="iban" name="iban" placeholder="IBAN (International Banc Account Number)" title="IBAN (International Banc Account Number)" value="${parametro !== null ? parametro.iban : ""}" required>
                          <small>Mensagem de erro</small>
                        </div>
                      </div>
                      <div class="col-md-2">
                        <div class="form-group" style="margin-bottom: 0;">
                          <small>Botão</small>
                          <button class="btn btn-block btn-outline-danger btn-remove" name="btn-submit"><i class="fas fa-minus"></i></button>
                        </div>
                        </div>
                      </div>
                    </div></div>`;
    $('#formularioBanco').append(container);
  }

  $(document).on('click', '.btn-remove', (e) => {
    e.preventDefault();
    const linha = $(e.target).closest('.linhaFormularioBanco');
    const linhas = document.querySelectorAll('.linhaFormularioBanco');
    for (let i = 0; i < linhas.length; i++) {
      if (linhas.length > 1) {
        linha.remove();
      }
    }
  });

  $(document).on('click', '#btn-add', () => {
    addRow(null);
  });

  $(document).ready(() => {
    funcaoSelect("../pos/includes/select.inc.php", "post", "json", "banco", function success(data) {
      if (Array.isArray(data)) {
        if (data.length > 0) {
          for (let i = 0; i < data.length; i++) {
            addRow(data[i]);
          }
        } else {
          addRow(null);
        }
      }
    }, function error(data) {

    }, function done(data) {

    });
  });

  $(document).on("click", "#btn-submit", function(e) {
    e.preventDefault();
    var boleano = true;
    const linhas = document.querySelectorAll('.linhaFormularioBanco');
    for (i = 0; i < linhas.length; i++) {
      if (linhas[i].querySelector('#nomeBanco').value === "" || linhas[i].querySelector('#numeroConta').value === "" || linhas[i].querySelector('#iban').value === "") {
        boleano = false;
      }
    }

    if (boleano) {
      const tabela = "banco";

      funcaoSelect("../pos/includes/select.inc.php", "post", "json", tabela, function success(data) {
        if (data) {
          for (let i = 0; i < data.length; i++) {
            funcaoDelete("../pos/includes/delete.inc.php", "post", "json", tabela, {
              idBanco: data[i].idBanco
            }, function success(data) {}, function error(data) {

            }, function done(data) {

            });
          }
        }
      }, function error(data) {

      }, function done(data) {
        funcaoAutoIncrementUpdate("../pos/includes/autoIncrementUpdate.inc.php", "post", "json", tabela, "1", function success(data) {}, function error(data) {

        }, function done(data) {
          const dados = {};
          const linhas = document.querySelectorAll('.linhaFormularioBanco');
          for (let i = 0; i < linhas.length; i++) {
            dados['nomeBanco'] = linhas[i].querySelector('#nomeBanco').value;
            dados['numeroConta'] = linhas[i].querySelector('#numeroConta').value;
            dados['iban'] = linhas[i].querySelector('#iban').value;
            funcaoInsert("../pos/includes/insert.inc.php", "post", "json", tabela, dados, function success(data) {}, function error(data) {}, function done(data) {
              swal.fire({
                title: "Bancos gravados com sucesso!",
                text: "Bancos cadastrados!",
                confirmButtonText: 'Confirmar',
                icon: "success",
              });
            });
          }
        });
      });
    } else {
      $(function() {
            var Toast = Swal.mixin({
              toast: true,
              position: 'top-end',
              showConfirmButton: false,
              timer: 3000
            });
            Toast.fire({
              icon: 'error',
              title: 'Erro ao gravar bancos, Preencha todos os campos, por favor.'
            });
          });
    }
  });
</script>