<?php include('./header.php'); ?>
<style type="text/css">
   .logo img {
      width: 150px;
   }

   .container .form-outer {
      width: 100%;
      overflow: hidden;
   }

   .form-outer .formulario {
      display: flex;
      width: 400%;
   }

   .form-outer .formulario .page {
      width: 25%;
      transition: margin-left 0.3s ease-in-out;
   }

   .form-outer .formulario .page .field {
      display: flex;
   }

   .form-outer .formulario .page .field button:hover {
      background-color: #66009f;
      border-color: #66009f;
   }

   .form-outer .formulario .page .field button {
      background-color: #560085;
      border-color: #560085;
   }

   .formulario .page .btns button.prev {
      margin-right: 3px !important;
      font-size: 17px;
   }

   .formulario .page .btns button.next {
      margin-left: 3px !important;
   }

   .container .progress-barra {
      display: flex;
      justify-content: space-between;
   }

   .container .progress-barra .step {
      position: relative;
      text-align: center;
      width: 100%;
      display: flex;
      align-items: center;
      justify-content: center;
      flex-direction: column;
   }

   .progress-barra .step p {
      font-size: 14px;
      font-weight: 500;
      color: #666;
      margin-bottom: 8px;
      transition: 0.2s;
   }

   .progress-barra .step p.active {
      color: #560085;
   }

   .progress-barra .step .bullet {
      position: relative;
      height: 35px;
      width: 35px;
      border: 2px solid #666;
      display: inline-block;
      border-radius: 50%;
      transition: 0.2s;
      display: flex;
      align-items: center;
      justify-content: center;
   }

   .progress-barra .step .bullet.active {
      border-color: #560085;
      background: #560085;
   }

   .progress-barra .step .bullet span {
      font-weight: 500;
      position: absolute;
      left: 50%;
      transform: translateX(-50%);
   }

   .progress-barra .step .bullet.active span {
      display: none;
   }

   .progress-barra .step:last-child .bullet:before,
   .progress-barra .step:last-child .bullet:after {
      display: none;
   }

   .progress-barra .step .bullet:before,
   .progress-barra .step .bullet:after {
      position: absolute;
      content: '';
      right: -14.35rem;
      height: 3px;
      width: 14rem;
      background: #666;
   }

   .progress-barra .step .bullet.active:after {
      background: #560085;
      transform: scaleX(0);
      transform-origin: left;
      animation: animate 0.3s linear forwards;
   }

   @keyframes animate {
      100% {
         transform: scaleX(1);
      }
   }

   .progress-barra .step .check {
      position: absolute;
      font-size: 15px;
      color: #666;
      display: none;
   }

   .progress-barra .step .check.active {
      display: block;
      color: #fff;
   }


   .archictecture {
      width: 100%;
      position: relative;
   }

   .treeview ul {
     list-style: none;
     margin-left: 20px;
   }

   .treeview-item {
     margin: 5px 0;
     position: relative;
   }

   .treeview-item .expand-icon {
     cursor: pointer;
     margin-right: 5px;
   }

   .treeview-item .tvItem {
     margin-right: 5px;
   }

   .treeview-item ul {
     display: none; /* Initially collapsed */
   }

   .treeview-item.collapsed > ul {
     display: none;
   }

   .treeview-item.expanded > ul {
     display: block;
   }

   .treeview-item ul.collapsing {
     transition: height 0.3s ease;
     overflow: hidden;
   }

   .treeview-item ul.expanding {
     transition: height 0.3s ease;
     overflow: hidden;
   }
</style>

<link rel="stylesheet" href="template/plugins/select2/css/select2.min.css">
<link rel="stylesheet" href="template/plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css">

<link rel="stylesheet" href="template/dist/css/bstreeview.min.css">

<body class="hold-transition layout-top-nav">
   <div class="wrapper">
      <div class="preloader flex-column justify-content-center align-items-center">
      </div>
      <!-- Content Wrapper. Contains page content -->
      <div class="content-wrapper">
         <!-- Content Header (Page header) -->
         <div class="content-header">
            <div class="container-fluid">
            </div><!-- /.container-fluid -->
         </div>
         <!-- /.content-header -->

         <section class="content">
            <div class="container">
               <div class="row">
                  <!-- SELECT2 EXAMPLE -->
                  <div class="col-md-10 mx-auto d-none">
                     <div class="card card-default">
                        <div class="card-body button-nav">
                           <div class="row float-right">
                              <div class="col-md-12">
                                 <button class="btn btn-opcao" id="btn-preview" disabled></button>
                                 <button class="btn btn-opcao"></button>
                                 <button class="btn btn-opcao botao-activo" id="btn">Atribuir Acesso</button>
                              </div>
                           </div>
                           <!-- /.row -->
                        </div>
                        <!-- /.card-body -->
                     </div>
                  </div>
                  <div class="col-md-10 mx-auto">
                     <div class="card card-default">
                        <div class="card-header">
                           <h3 class="card-title">Listagem dos Menus</h3>
                           <div class="card-tools">
                              <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                 <i class="fas fa-minus"></i>
                              </button>
                              <button type="button" class="btn btn-tool" data-card-widget="remove">
                                 <i class="fas fa-times"></i>
                              </button>
                           </div>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                           <div class="row">
                              <div class="col-md-6">
                                 <span class="text-bold d-block mb-3">Adicionar Menu</span>
                                 <form action="" method="post" id="tipoUsuarioForm">
                                    <div class="col-12">
                                       <div class="form-group">
                                          <small class="required">Selecionar Tipo de Usuário</small>
                                          <select name="tipoUsuario" id="selectMenuNode" class="form-control" required>
                                             <option value="">-- Selecionar um Grupo de Usuário --</option>
                                             <option value="">...</option>
                                          </select>
                                          <small>Mensagem de erro</small>
                                       </div>
                                    </div>
                                    <div class="col-12 d-none">
                                       <div class="form-group">
                                          <small class="required">Inserir nome do Menu</small>
                                          <input type="text" id="" name="" placeholder="Nome do menu..." class="form-control">
                                          <small>Mensagem de erro</small>
                                       </div>
                                    </div>
                                    <div class="col-12 col-md-6">
                                       <div class="form-group">
                                          <button type="submit" class="btn btn-primary btn-block" id="btnSubmit">Limitar Acesso</button>
                                       </div>
                                    </div>
                                 </form>
                              </div>
                              <div class="col-md-6">
                                 <span class="text-bold d-block mb-3">Menus</span>
                                 <div class="archictecture"></div>
                                 <div class="tv"></div>
                              </div>
                           </div>
                        </div>
                        <!-- /.card-body -->
                        <div class="card-footer">
                           <!-- Listagem dos Terminals. -->
                        </div>
                     </div>
                  </div>
               </div>
               <!-- /.card -->
            </div>
            <!-- /.container-fluid -->
         </section>
         <div class="modal fade" id="modal-documento">
            <div class="modal-dialog modal-xl">
               <div class="modal-content">
                  <div class="modal-header">
                     <div class="container">
                        <div class="progress-barra">
                           <div class="step">
                              <p style="margin: 0;">Formulário de Atribuição de Accesso</p>
                           </div>
                        </div>
                     </div>
                  </div>
                  <div class="modal-body">
                     <div class="container">
                        <div class="card-body form-outer" style="padding: 0;">
                           <div class="row">
                              <div class="col-md-4">
                                 <form action="" method="post">
                                    <div class="col-md-12">
                                       <div class="form-group">
                                          <small class="required">Selecione o Usuário</small>
                                          <select name="" id="" class="select2"></select>
                                       </div>
                                    </div>
                                    <div class="col-md-12">
                                       <div class="form-group">
                                          <small class="required">Menus Permetidos</small>
                                          <select name="" id="" class="select2"></select>
                                       </div>
                                    </div>
                                    <div class="col-md-12">
                                       <div class="form-group">
                                          <small class="required">Acesso Restrictos</small>
                                          <select name="" id="select2Users" class="select2"></select>
                                       </div>
                                    </div>
                                    <div class="col-md-12">
                                       <div class="form-group">
                                          <button type="submit" class="btn btn-primary btn-block">Salvar</button>
                                       </div>
                                    </div>
                                 </form>
                              </div>
                              <div class="col-md-4">
                                 <button type="button" class="btn btn-primary btn-lg">Adicionar</button>
                                 <button type="button" class="btn btn-primary btn-lg">Remover</button>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
               <!-- /.modal-content -->
            </div>
            <!-- /.modal-dialog -->
         </div>
      </div>

      <!-- /.content-wrapper -->
      <?php include('footer.php'); ?>
</body>

<input type="hidden" id="groupItems">

</html>
<script src="template/dist/js/bstreeview.min.js"></script>

<script>
   let treeView = [];
   $(document).ready(function() {
     $('#btn').click(function() {
       $('#modal-documento').modal('show');
     });

     $('[name="tipoUsuario"]').change(function() {
       let usersType = $('#groupItems').val().split(';');
       let types = [];
       usersType.forEach(type => {
         if (type.includes($(this).val())) {
           var partType = type.split('-');
           var userType = {
             grupo: partType[0],
             user_id: partType[1]
           };
           types.push(userType);
         }
       });

       funcaoSelect("../pos/includes/select.inc.php", "post", "json", "user_access", function success(data) {}, function error(data) {}, function done(data) {
         let restrictedItems = [];
         data.forEach(access => {
           if (types[0].user_id == access.user_id) {
             restrictedItems.push(access.menu_item_id);
           }
         });
         // getTree($('.archictecture'), treeViewData);
         updateTreeView(treeViewData);
         restrictedItems.forEach(restricto => {
            $('#treeviewItem-'+restricto).prop('checked', false);
         });
       });
     });
   });


   $(document).ready(function() {
      /*
         ARMAZENA O CONTROL DE ACESSO NA BD: user_access
      */
      $('#tipoUsuarioForm').submit(function(e) {
         e.preventDefault();
         var getTipoUsuario = $('[name="tipoUsuario"]').val();
         let usersType = $('#groupItems').val().split(';');
         let userType;

         if (getTipoUsuario) {
            usersType.forEach(type => {
               if (type.includes(getTipoUsuario)) {
                  var partType = type.split('-');
                  userType = {
                     grupo: partType[0],
                     user_id: partType[1]
                  };
               }
            });
            let dataToStore = [];
            var todosTreeviewItens = document.querySelectorAll('.tvItem');
            todosTreeviewItens.forEach(tvItem => {
               if (!tvItem.checked) {
                  let controlAcesso = {
                     user_id: userType.user_id,
                     grupo: userType.grupo,
                     menu_item_id: tvItem.id.split('-')[1],
                     access_level: 0
                  };
                  dataToStore.push(controlAcesso);
               }
            });

            funcaoDelete("../pos/includes/delete.inc.php", "post", "json", 'user_access', {
               user_id: userType.user_id
            }, function success(data) {
               if (dataToStore.length == 0) {
                  swal.fire({
                     title: "Control de Acesso",
                     text: "Assumindo o controle total",
                     icon: "success",
                     confirmButtonText: 'Confirmar',
                     confirmButtonColor: '#560085',
                  });
                  return;
               }
               dataToStore.forEach(currentObjectData => {
                  funcaoInsert("../pos/includes/insert.inc.php", "post", "json", 'user_access', currentObjectData, function success(data) {}, function error(data) {
                     swal.fire({
                        title: "Erro ao cadastrar Tipo de Usuário!",
                        text: "Erro ao cadastrar Tipo de Usuário: ",//+ nome.value + " !",
                        confirmButtonText: 'Confirmar',
                        confirmButtonColor: '#560085',
                        icon: "error",
                     });
                  }, function done(data) {
                     swal.fire({
                        title: "Control de Acesso",
                        text: "Acesso Restricto com Sucesso.",
                        icon: "success",
                        confirmButtonText: 'Confirmar',
                        confirmButtonColor: '#560085',
                     });
                  });
               });

            }, function error(data) {
               console.log(data);
               swal.fire({
                  title: "Erro ao eliminar Tipo de Usuário!",
                  text: "Tipo de Usuário associado a uma ou mais Documentos.",
                  icon: "error",
                  confirmButtonText: 'Confirmar',
                  confirmButtonColor: '#560085',
               });
            }, function done(data) {});
         } else {
            swal.fire({
               title: "Erro ao eliminar Atribuir Acesso ao Tipo de Usuário!",
               text: "Deves selecionar o Tipo de Usuário antes de Continuar.",
               icon: "error",
               confirmButtonText: 'Confirmar',
               confirmButtonColor: '#560085',
            });
         }



      });
   });



   // Carrega os tipos de Usuario

   funcaoSelect("../pos/includes/select.inc.php", "post", "json", "tipousuario", function success(data) {}, function error(data) {

   }, function done(data) {
      var Users = [];
      var ItemV = '';
      data.forEach((item, index) => {
         ItemV += item.nome + '-' + item.idTipoUsuario + ';';
         Users.push(item.nome);
      });
      $('#groupItems').val(ItemV);

      $('#selectMenuNode').select2({
         width: '100%',
         placeholder: 'Selecione um Grupo de Usuário',
         allowClear: true,
         data: Users,
         minimumResultsForSearch: 1,
         dropdownAutoWidth: true
      });
   });


   // Carrega Todos os Menus

   funcaoSelect("../pos/includes/select.inc.php", "post", "json", "menus", function success(data) {}, function error(data) {

   }, function done(data) {
      treeViewData = buildTreeView(data);
      // getTree($('.archictecture'), treeViewData);
      updateTreeView(treeViewData);
      // $('.archictecture').empty();

      // getTree($('.archictecture'), []);

   });

   
   function buildTreeView(items, parentId = null) {
     let branch = [];

     items.forEach(item => {
       if (item.parent_id === parentId) {
         let children = buildTreeView(items, item.menu_id);      
         let node = {
           text: item.text || `<input type="checkbox" class="form-checkbox tvItem" id="treeviewItem-${item.menu_id}" checked>` + item.item,
           icon: item.icon || '',
           nodes: children.length ? children : undefined,
           id: item.menu_id,
           class: item.class,
           href: item.href
         };

         Object.keys(node).forEach(key => node[key] === undefined && delete node[key]);

         branch.push(node);
       }
     });

     return branch;
   }

   function getTree(item, data) {
      $(item).bstreeview({
        data: data,
        expandIcon: 'fa fa-minus fa-fw',
        collapseIcon: 'fa fa-plus fa-fw',
        indent: 1.25,
        parentsMarginLeft: '2.25rem',
        openNodeLinkOnNewTab: true
      });
   }

   function updateTreeView(data) {
     let container = $('.archictecture');
     container.empty();
     container.append(createTree(data));
   }

   function createTree(data) {
     let ul = $('<ul>');
     let expandedNodes = JSON.parse(localStorage.getItem('expandedNodes')) || [];

     data.forEach(item => {
       let li = $('<li>').addClass('treeview-item');

       // Verifica se o nó estava expandido anteriormente
       if (expandedNodes.includes(item.id)) {
         li.addClass('expanded');
       } else {
         li.addClass('collapsed');
       }

       if (item.nodes && item.nodes.length > 0) {
         let expandIcon = $('<i>').addClass('fa fa-plus fa-fw expand-icon').on('click', function() {
           let ulElement = li.children('ul');
           if (ulElement.is(':visible')) {
             ulElement.addClass('collapsing').css('height', ulElement.height());
             setTimeout(() => {
               ulElement.css('height', 0);
             }, 10);
             setTimeout(() => {
               ulElement.removeClass('collapsing').css('height', '');
               ulElement.hide();
               $(this).toggleClass('fa-minus fa-plus');
               li.toggleClass('expanded collapsed');
               updateExpandedNodes(item.id, false);
             }, 310);
           } else {
             ulElement.show();
             let height = ulElement[0].scrollHeight;
             ulElement.addClass('expanding').css('height', 0);
             setTimeout(() => {
               ulElement.css('height', height);
             }, 10);
             setTimeout(() => {
               ulElement.removeClass('expanding').css('height', '');
               $(this).toggleClass('fa-minus fa-plus');
               li.toggleClass('expanded collapsed');
               updateExpandedNodes(item.id, true);
             }, 310);
           }
         });
         li.append(expandIcon);
       }

       li.append(item.text);
       
       if (item.nodes && item.nodes.length > 0) {
         li.append(createTree(item.nodes));
       }

       ul.append(li);
     });

     return ul;
   }

   function updateExpandedNodes(nodeId, isExpanded) {
     let expandedNodes = JSON.parse(localStorage.getItem('expandedNodes')) || [];
     if (isExpanded) {
       if (!expandedNodes.includes(nodeId)) {
         expandedNodes.push(nodeId);
       }
     } else {
       expandedNodes = expandedNodes.filter(id => id !== nodeId);
     }
     localStorage.setItem('expandedNodes', JSON.stringify(expandedNodes));
   }



</script>