<?php $page = 'familia';
include('header.php'); ?>

<body class="hold-transition layout-top-nav">
  <div class="wrapper">
    <div class="preloader flex-column justify-content-center align-items-center">
      <img class="animation__shake" src="images/logo/<?php echo $rows[9]['valor']; ?>" alt="AdminLTELogo" height="60" width="60">
    </div>
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
      <!-- Content Header (Page header) -->
      <div class="content-header">
        <div class="container-fluid">
        </div><!-- /.container-fluid -->
      </div>
      <!-- /.content-header -->
      <section class="content">
        <div class="container-fluid">
          <div class="row">
            <!-- SELECT2 EXAMPLE -->
            <div class="col-md-6">
              <div class="card card-default">
                <div class="card-header">
                  <h3 class="card-title">Grupo de Usuário</h3>

                  <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                      <i class="fas fa-minus"></i>
                    </button>
                    <button type="button" class="btn btn-tool" data-card-widget="remove">
                      <i class="fas fa-times"></i>
                    </button>
                  </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                  <div class="row">
                    <div class="col-md-12">
                      <div class="form-group margem" style="margin-bottom: 0;">
                        <small class="not-required">Código</small>
                        <div class="input-group input-group">
                          <input type="text" class="form-control form-control" id="codigo" name="codigo" placeholder="Pesquisar Grupo de Entidade" title="Pesquisar Grupo de Entidade" disabled>
                          <div class="input-group-append">
                            <button type="button" id="btn-search" class="btn btn btn-default" style="line-height: 0 ;">
                              <i class="fa fa-search"></i>
                            </button>
                          </div>
                        </div>
                        <small>Mensagem de erro</small>
                      </div>
                      <div class="form-group" style="margin-bottom: 0;">
                        <small class="required">Grupo de Usuário</small>
                        <input type="text" class="form-control" id="nome" name="nome" placeholder="Grupo de Usuário" title="Grupo de Usuário" required>
                        <small>Mensagem de erro</small>
                      </div>
                      <div class="form-group" style="margin-bottom: 0;">
                        <small class="not-required">Nota</small>
                        <textarea name="nota" id="nota" class="form-control" placeholder="Nota..." rows="4"></textarea>
                        <small>Mensagem de erro</small>
                      </div>
                    </div>
                    <div class="col-md-6"></div>
                    <div class="col-md-6">
                      <div class="form-group">
                        <button type="submit" name="btn-submit" id="btn-submit" class="btn btn-block btn-primary">Cadastrar Grupo de Usuário</button>
                      </div>
                    </div>
                    <!-- /.col -->
                  </div>
                  <!-- /.row -->
                </div>
                <!-- /.card-body -->
                <div class="card-footer">
                  Cadastro Grupo de Usuário.
                </div>
              </div>
            </div>
          </div>
          <!-- /.card -->
        </div>
        <!-- /.container-fluid -->
      </section>
    </div>
    <!-- /.content-wrapper -->
    <?php include('footer.php'); ?>
</body>

</html>
<script src="./validation/grupoUsuario.js"></script>
<script>
  $(document).ready(function() {
    codigoGrupoUsuario();
  });

  $(document).on("click", "#btn-submit", function(e) {
    e.preventDefault();
    if (nome.value != '') {
      $.ajax({
        url: "includes/create/grupoUsuario.inc.php",
        type: "post",
        data: {
          nome: nome.value,
          nota: nota.value
        },
        success: function(data) {
          codigoGrupoUsuario();
          swal.fire({
            title: "Cadastro efectuado com sucesso!",
            text: "Grupo de Usuário " + nome.value + " cadastrado!",
            confirmButtonText: 'Confirmar',
            icon: "success",
          });
          nome.value = "";
          nome.className = "form-control";
          nota.value = "";
          nota.className = "form-control";
        },
        error: function(data) {
          swal.fire({
            title: "Erro ao Cadastrar Grupo de Usuário!",
            text: "Erro ao Cadastrar Grupo de Usuário: " + nome.value + " !",
            confirmButtonText: 'Confirmar',
            icon: "error",
          });
        }
      }).done(function(data) {
        console.log(data);
      });
    }
  });
</script>