<!DOCTYPE html>
<html lang="pt">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invoice</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-T3c6CoIi6uLrA9TneNEoa7RxnatzjcDSCmG1MXxSR1GAsXEV/Dwwykc2MPK8M2HN" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" integrity="sha512-z3gLpd7yknf1YoNbCzqRKc4qyor8gaKU1qmn+CShxbuBusANI9QpRohGBreCFkKxLhei6S9CQXFEbbKuqLg0DA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
    <style>
        :root {
            --body-bg: rgb(204, 204, 204);
            --white: #ffffff;
            --darkWhite: #ccc;
            --black: #000000;
            --dark: #615c60;
            --themeColor: #560085;
            --pageShadow: 0 0 0.5cm rgba(0, 0, 0, 0.5);
        }

        @import url('https://fonts.googleapis.com/css2?family=Noto+Sans:ital,wght@0,100;0,200;0,300;0,400;0,500;1,100&display=swap');

        body {
            background-color: var(--body-bg);
            -webkit-print-color-adjust: exact !important;
        }


        .page {
            background: var(--white);
            display: block;
            margin: 0 auto;
            position: relative;
            box-shadow: var(--pageShadow);
        }

        .page[size="A4"] {
            width: 21cm;
            min-height: 29.7cm;
            overflow: hidden;
        }

        .bb {
            border-bottom: 3px solid var(--darkWhite);
        }

        .top-content {
            padding-bottom: 15px;
        }

        .logo img {
            height: 30px;
        }

        .top-left p {
            margin: 0;
        }

        .top-left .graphic-path {
            height: 40px;
            position: relative;
        }

        .top-left .graphic-path::before {
            content: "";
            height: 20px;
            background-color: var(--dark);
            position: absolute;
            left: 15px;
            right: 0;
            top: -15px;
            z-index: 2;
        }

        .top-left .graphic-path::after {
            content: "";
            height: 22px;
            width: 17px;
            background: var(--black);
            position: absolute;
            top: -13px;
            left: 6px;
            transform: rotate(45deg);
        }

        .top-left .graphic-path p {
            color: var(--white);
            height: 40px;
            left: 0;
            right: -100px;
            text-transform: uppercase;
            background-color: var(--themeColor);
            font: 26px;
            z-index: 3;
            position: absolute;
            padding-left: 10px;
        }

        .store-user {
            padding-bottom: 25px;
        }

        .store-user p {
            margin: 0;
            font-weight: 600;
        }

        .store-user .address {
            font-weight: 400;
        }

        .store-user h2 {
            color: var(--themeColor);
            font-family: 'Rajdhani', sans-serif;
        }

        .extra-info p span {
            font-weight: 400;
        }

        .table td,
        .table th {
            text-align: center;
            vertical-align: middle;
        }

        tr th:first-child,
        tr td:first-child {
            text-align: left;
        }

        .media img {
            height: 60px;
            width: 60px;
        }

        .media p {
            font-weight: 400;
            margin: 0;
        }

        .media p.title {
            font-weight: 600;
        }

        .media-body>p {
            font-weight: 600;
        }

        .balance-info .table td,
        .balance-info .table th {
            padding: 0;
            border: 0;
        }

        .balance-info tr td:first-child {
            font-weight: 600;
        }

        tfoot {
            border-top: 2px solid var(--darkWhite);
        }

        tfoot td {
            font-weight: 600;
        }

        footer {
            text-align: center;
            position: absolute;
            bottom: 30px;
            left: 0;
            right: 0;
            background: var(--white);
            padding: 3rem;
        }

        footer hr {
            margin-bottom: -22px;
            border-top: 3px solid var(--darkWhite);
        }

        footer a {
            color: var(--themeColor);
        }

        @media print {

            .page,
            .page * {
                visibility: visible;
            }

            .page {
                position: absolute;
                left: 0;
                top: 0;
                box-shadow: none;
            }

            .my-5 {
                margin: 0 !important;
            }

            @page {
                margin: 0;
            }
        }

        .tabela thead td {
            background-color: #0000000d;
        }

        .tabela td {
            text-align: left;
        }

        .tabela-principal thead {
            font-weight: 600;
        }

        .tabela-principal thead td {
            background: none;
            border-bottom: 1px solid #000;
        }

        .tabela-principal td {
            border: none;
        }

        .marca-dagua {
            position: relative;
            width: 100%;
            height: 100%;
        }

        .marca-dagua::before {
            content: var(--content, '');
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%) rotate(-45deg);
            font-size: 10rem;
            color: #bcbcbc;
        }
    </style>
</head>

<body>

    <div id="layoutDocA4"></div>

    <!-- <div class="my-5 page marca-dagua" size="A4">
        <div class="p-5">
            <section class="top-content d-flex justify-content-between" style="padding-bottom: 0; padding-top: 1.5rem;">
                <div class="col-7">
                    <div class="logo">
                        <img src="logo.svg" alt="" class="img-fluid" id="logotipoDocumento">
                    </div>
                </div>
                <div class="col-5">
                    <p style="font-size: 14pt; font-family: 'Noto Sans', sans-serif; text-align: justify; background-color: #560085; color: #fff; padding-left: .5rem;"><span id="nomeTipoDocumento"></span><span id="codDocumento" style="float: right; padding-right: .5rem;"></span></p>
                </div>
            </section>
            <section class="store-user" style="padding-bottom: 0;">
                <div class="col-12">
                    <div class="row pb-3">
                        <div class="col-7">
                            <p style="font-size: 6pt; font-family: 'Noto Sans', sans-serif; text-align: justify; font-weight: 400;" id="enderecoDocumento"></p>
                            <p style="font-size: 6pt; font-family: 'Noto Sans', sans-serif; text-align: justify; font-weight: 400;">Nº
                                Contribuinte: <span id="nifDocumento"></span></p>
                            <p style="font-size: 6pt; font-family: 'Noto Sans', sans-serif; text-align: justify; font-weight: 400;">
                                Telefone: <span id="telefoneDocumento"></span></p>
                            <p style="font-size: 6pt; font-family: 'Noto Sans', sans-serif; text-align: justify; font-weight: 400;">Email:
                                <span id="emailDocumento"></span>
                            </p>
                            <p style="font-size: 6pt; font-family: 'Noto Sans', sans-serif; text-align: justify; font-weight: 400;" id="websiteDocumento"></p>
                        </div>
                        <div class="col-5">
                            <p style="font-size: 6pt; font-family: 'Noto Sans', sans-serif; text-align: justify; margin-bottom: 0.3rem;">
                                CLIENTE: <span style="font-weight: 400;" id="clienteDocumento"></span></p>
                            <p style="font-size: 6pt; font-family: 'Noto Sans', sans-serif; text-align: justify; margin-bottom: 0.3rem;">
                                MORADA: <span style="font-weight: 400;" id="moradaDocumento"></span></p>
                            <p style="font-size: 6pt; font-family: 'Noto Sans', sans-serif; text-align: justify;">DATA
                                EMISSÃO: <span style="font-weight: 400;" id="dataEmissaoDocumento"></span style="font-weight: 400;"> &nbsp; DATA VENCIMENTO: <span style="font-weight: 400;" id="dataVencimentoDocumento"></span></p>
                            <p style="font-size: 6pt; font-family: 'Noto Sans', sans-serif; text-align: justify;">
                                DESCONTO: <span style="font-weight: 400;">0,00%</span></p>
                            <p style="font-size: 6pt; font-family: 'Noto Sans', sans-serif; text-align: justify;">
                                PAGAMENTO: <span style="font-weight: 400;" id="modoPagamentoDocumento"></span></p>
                            <p style="font-size: 6pt; font-family: 'Noto Sans', sans-serif; text-align: justify;">NIF:
                                <span style="font-weight: 400;" id="nifDocumento"></span>
                            </p>
                        </div>
                    </div>
                </div>
            </section>
            <section class="product-area mt-4">
                <table class="tabela-principal table table-hover table-sm" style="font-size: 7pt; font-family: 'Noto Sans', sans-serif; text-align: justify;">
                    <thead>
                        <tr>
                            <td>DOCUMENTO</td>
                            <td>TIPO DOCUMENTO</td>
                            <td>DATA DOCUMENTO</td>
                            <td>ENTREGUE</td>
                            <td>EM FALTA</td>
                            <td>TOTAL</td>
                            <td>PRAZO</td>
                        </tr>
                    </thead>
                    <tbody id="tabelaDocumento">
                    </tbody>
                </table>
            </section>
            <footer>
                <section class="balance-info">
                    <div class="row">
                        <div class="col-12">
                            <p class="m-0 font-weight-bold" style="font-weight: 600; font-size: 7pt; font-family: 'Noto Sans', sans-serif; text-align: justify;">
                                RESUMO DE IMPOSTOS: </p>
                        </div>
                        <div class="col-8">
                            <table class="tabela table border-0 table-hover" style="font-size: 7pt; font-family: 'Noto Sans', sans-serif; text-align: justify;">
                                <thead style="font-weight: 600; color: #0000000d;">
                                    <tr>
                                        <td style="width: 10rem;">DESIGNAÇÃO</td>
                                        <td style="width: 8rem;">TAXA</td>
                                        <td>INCIDÊNCIA</td>
                                        <td>IMPOSTO</td>
                                    </tr>
                                </thead>
                                <tbody id="incidencia">

                                </tbody>
                            </table>
                            <div class="col-12">
                                <p class="m-0 font-weight-bold" style="font-weight: 600; font-size: 7pt; font-family: 'Noto Sans', sans-serif; text-align: justify;">
                                    MODOS DE PAGAMENTO: </p>
                            </div>
                            <table class="tabela table border-0 table-hover" style="font-size: 7pt; font-family: 'Noto Sans', sans-serif; text-align: justify;">
                                <thead style="font-weight: 600; color: #0000000d;">
                                    <tr>
                                        <td style="width: 10rem;">DESCRIÇÃO</td>
                                        <td style="width: 8rem;">TOTAL</td>
                                        <td>INFORMAÇÃO ADICIONAL</td>
                                    </tr>
                                </thead>
                                <tbody id="tabelaModoPagamentoDocumento"></tbody>
                            </table>
                            <div class="col-12">
                                <p class="m-0 font-weight-bold" style="font-weight: 600; font-size: 7pt; font-family: 'Noto Sans', sans-serif; text-align: justify;">
                                    COORDENADAS BANCÁRIAS: </p>
                            </div>
                            <table class="tabela table border-0 table-hover" style="font-size: 7pt; font-family: 'Noto Sans', sans-serif; text-align: justify;">
                                <thead style="font-weight: 600; color: #0000000d;">
                                    <tr>
                                        <td style="width: 10rem;">BANCO</td>
                                        <td style="width: 8rem;">NÚMERO DA CONTA</td>
                                        <td>IBAN</td>
                                    </tr>
                                </thead>
                                <tr>
                                    <td>abcd</td>
                                    <td>efgh</td>
                                    <td>ijkl</td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-4">
                            <table class="table border-0 table-hover table-striped" style="font-size: 7pt; font-family: 'Noto Sans', sans-serif; text-align: justify;">
                                <tr>
                                    <td>MERCADORIAS/SERVIÇOS:</td>
                                    <td style="text-align: right;" id="mercadoriaServicoDocumento"></td>
                                </tr>
                                <tr>
                                    <td>DESCONTO GLOBAL:</td>
                                    <td style="text-align: right;" id="descontoGlobalDocumento"></td>
                                </tr>
                                <tr>
                                    <td>LÍQUIDO:</td>
                                    <td style="text-align: right;" id="totalLiquidoDocumento"></td>
                                </tr>
                                <tr>
                                    <td>IMPOSTO IVA:</td>
                                    <td style="text-align: right;" id="impostoIvaDocumento"></td>
                                </tr>
                                <tr>
                                    <td>RETENÇÃO 0,00%:</td>
                                    <td style="text-align: right;" id="retencaoDocumento"></td>
                                </tr>
                                <tr>
                                    <td>TOTAL DO DOCUMENTO:</td>
                                    <td style="text-align: right;" id="totalDocumento"></td>
                                </tr>
                            </table>
                            <div class="col-12">
                                <p id="paragrafoProforma" class="m-0" style="color: #8F8F8F; font-size: 5pt; font-family: 'Noto Sans', sans-serif; text-align: justify;">
                                    Este Documento é válido por oito dias. Valor de Referência para
                                    Luanda e arredores, restantes provincias a negociar. Garantia: Suporte contínuo
                                    enquato
                                    durar a vigência do contracto de prestação de serviço.
                                    Exclusões: Estão excluídos desta proposta, Serviços adicionais que carecem de
                                    concertação prévia antes de serem executados, serviços de manutenção a
                                    infraestrutura de
                                    rede do cliente e ou de computadores que tenha apresentado avarias no seu
                                    funcionamento.
                                </p>
                            </div>
                        </div>
                    </div>
                </section>
            </footer>
        </div>
    </div> -->
    <script src="template/plugins/jquery/jquery.min.js"></script>
    <script>
        // document.addEventListener('DOMContentLoaded', function() {

        // });

        const docData = {};
        const mainDoc = document.querySelector('#layoutDocA4');

        function openDoc() {
            return `
                <div class="my-5 page marca-dagua" size="A4">
                    <div class="p-5">
            `;
        }

        function buildHeaderSection() {
            // console.log(docData);
            const headerSectionHTML = `
                <section class="top-content d-flex justify-content-between" style="padding-bottom: 0; padding-top: 1.5rem;">
                    <div class="col-7">
                        <div class="logo" style="position: relative; height: 90px;">
                            <img src="${'./images/logo/'+docData['configuracao']['logotipoDocumento']}" alt="" class="img-fluid w-90 h-100" id="logotipoDocumento">
                        </div>
                    </div>
                    <div class="col-5">
                        <p style="font-size: 14pt; font-family: 'Noto Sans', sans-serif; text-align: justify; background-color: #1F4999; color: #fff; padding-left: .5rem;">
                            <span id="nomeTipoDocumento">${docData['outrosDocumento']['nomeTipoDocumento']}</span>
                            <span id="codDocumento" style="float: right; padding-right: .5rem;">${docData['outrosDocumento']['codDocumento']}</span>
                        </p>
                    </div>
                </section>
            `;
            return headerSectionHTML;
        }

        function buildStoreUserSection() {
            const storeUserSectionHTML = `
                <section class="store-user" style="padding-bottom: 0;">
                    <div class="col-12">
                        <div class="row pb-3">
                            <div class="col-7">
                                
                                <p style="font-size: 8pt; font-family: 'Noto Sans', sans-serif; text-align: justify; font-weight: 400;" id="enderecoDocumento">${docData["configuracao"]["enderecoDocumento"]}</p>
                                <p style="font-size: 8pt; font-family: 'Noto Sans', sans-serif; text-align: justify; font-weight: 400;">Nº
                                    Contribuinte: <span id="nifDocumento">${docData["configuracao"]["nifDocumento"]}</span></p>
                                <p style="font-size: 8pt; font-family: 'Noto Sans', sans-serif; text-align: justify; font-weight: 400;">
                                    Telefone: <span id="telefoneDocumento">${docData["configuracao"]["telefoneDocumento"]}</span></p>
                                <p style="font-size: 8pt; font-family: 'Noto Sans', sans-serif; text-align: justify; font-weight: 400;">Email:
                                    <span id="emailDocumento">${docData["configuracao"]["emailDocumento"]}</span>
                                </p>
                                <p style="font-size: 8pt; font-family: 'Noto Sans', sans-serif; text-align: justify; font-weight: 400;" id="websiteDocumento">${docData["configuracao"]["websiteDocumento"]}</p>
                            </div>
                            <div class="col-5">
                                <p style="font-size: 6pt; font-family: 'Noto Sans', sans-serif; text-align: justify; margin-bottom: 0.3rem;">
                                    CLIENTE: <span style="font-weight: 400;" id="clienteDocumento">${docData['outrosDocumento']['clienteDocumento']}</span></p>
                                <p style="font-size: 6pt; font-family: 'Noto Sans', sans-serif; text-align: justify; margin-bottom: 0.3rem;">
                                    MORADA: <span style="font-weight: 400;" id="moradaDocumento">${docData['outrosDocumento']['moradaDocumento']}</span></p>
                                <p style="font-size: 6pt; font-family: 'Noto Sans', sans-serif; text-align: justify;">DATA
                                    EMISSÃO: <span style="font-weight: 400;" id="dataEmissaoDocumento">${docData['outrosDocumento']['dataEmissaoDocumento']}</span style="font-weight: 400;"> &nbsp; DATA VENCIMENTO: <span style="font-weight: 400;" id="dataVencimentoDocumento">${docData['outrosDocumento']['dataVencimentoDocumento']}</span></p>
                                <p style="font-size: 6pt; font-family: 'Noto Sans', sans-serif; text-align: justify;">
                                    DESCONTO: <span style="font-weight: 400;">0,00%</span></p>
                                <p style="font-size: 6pt; font-family: 'Noto Sans', sans-serif; text-align: justify;">
                                    PAGAMENTO: <span style="font-weight: 400;" id="modoPagamentoDocumento">${docData['outrosDocumento']['modoPagamentoDocumento']}</span></p>
                                <p style="font-size: 6pt; font-family: 'Noto Sans', sans-serif; text-align: justify;">NIF:
                                    <span style="font-weight: 400;" id="nifDocumento">${docData['outrosDocumento']['nifDocumento']}</span>
                                </p>
                            </div>
                        </div>
                    </div>
                </section>
            `;



            return storeUserSectionHTML;
        }

        // let row = "";
        var incideNOR = 0;
        var ipostoNOR = 0;
        var incideRED = 0;
        var ipostoRED = 0;
        var incideICB = 0;
        var ipostoICB = 0;
        var incideISE = 0;
        var ipostoISE = 0;
        var descrNOR = '';
        var descrRED = '';
        var descrICB = '';
        var descrISE = '';

        function buildProductSection(dataLine) {
            let row = '';
            let productSectionHTML = `
                <section class="product-area mt-4">
                    <table class="tabela-principal table table-hover table-sm" style="font-size: 7pt; font-family: 'Noto Sans', sans-serif; text-align: justify;">
                        <thead>
                            <tr>
                                <td>REF.</td>
                                <td>DESCRIÇÃO</td>
                                <td>DATA/HORA</td>
                                <td>PREÇO/UNIT.</td>
                                <td>DESC.</td>
                                <td>VALOR PAGO</td>
                                <td style="text-align: right !important">TOTAL</td>
                            </tr>
                        </thead>
                        <tbody id="tabelaDocumento">
            `;

            for (const key in dataLine) {
                row += `
                        <tr>
                        <td>${dataLine[key]['codigoDocumento']}</td>
                        <td>${dataLine[key]['nomeTd']}</td>
                        <td>${dataLine[key]['dataDoc']}</td>
                        <td style="text-align: right !important">${parseFloat(dataLine[key]['entregueDocRelac']).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</td>
                        <td>${parseFloat(dataLine[key]['faltaDocRelac']).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</td>
                        <td>${parseFloat(dataLine[key]['total']).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</td>
                        <td style="text-align: right !important">${dataLine[key]['nomePp']}</td>
                        </tr>
                `;

                console.log("DATALINE IIIIIIIIIII: ", dataLine[key]['idImposto']);

                if (dataLine[key]['idImposto'] == 1) {
                    incideNOR = dataLine[key]['totalAd'] + incideNOR;
                    ipostoNOR = dataLine[key]['imposto'] + ipostoNOR;
                    descrNOR = dataLine[key]['nome'];
                } else if (dataLine[key]['idImposto'] == 2) {
                    incideRED = dataLine[key]['totalAd'] + incideRED;
                    ipostoRED = dataLine[key]['imposto'] + ipostoRED;
                    descrRED = dataLine[key]['nome'];
                } else if (dataLine[key]['idImposto'] == 3) {
                    incideICB = dataLine[key]['totalAd'] + incideICB;
                    ipostoICB = dataLine[key]['imposto'] + ipostoICB;
                    descrICB = dataLine[key]['nome'];
                } else if (dataLine[key]['idImposto'] == 4) {
                    incideISE = dataLine[key]['totalAd'] + incideISE;
                    ipostoISE = dataLine[key]['imposto'] + ipostoISE;
                    descrISE = dataLine[key]['nome'];
                }
                productSectionHTML += row;
                row = "";
            }
            productSectionHTML += `
                        </tbody>
                    </table>
                </section>
            `;
            return productSectionHTML;
        }

        function buildFooter() {
            let incidNew = '';
            if (descrNOR != '') {
                incidNew = `
                    <tr>
                        <td>${descrNOR}</td>
                        <td>14%</td>
                        <td>${parseFloat(incideNOR).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</td>
                        <td>${parseFloat(ipostoNOR).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</td>
                    </tr>`;
            }
            if (descrRED != '') {
                incidNew += `
                    <tr>
                        <td>${descrRED}</td>
                        <td>7%</td>
                        <td>${parseFloat(incideRED).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</td>
                        <td>${parseFloat(ipostoRED).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</td>
                    </tr>`;
            }
            if (descrICB != '') {
                incidNew += `
                    <tr>
                        <td>${descrICB}</td>
                        <td>5%</td>
                        <td>${parseFloat(incideICB).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</td>
                        <td>${parseFloat(ipostoICB).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</td>
                    </tr>`;
            }
            if (descrISE != '') {
                incidNew += `
                    <tr>
                        <td>${descrISE}</td>
                        <td>0%</td>
                        <td>${parseFloat(incideISE).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</td>
                        <td>${parseFloat(ipostoICB).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</td>
                    </tr>`;
            }

            // console.log("IIIIIII: ", incidNew);

            let footerSectionHTML = `
                <footer>
                    <section class="balance-info">
                        <div class="row">
                            <div class="col-12 d-none">
                                <p class="m-0 font-weight-bold" style="font-weight: 600; font-size: 7pt; font-family: 'Noto Sans', sans-serif; text-align: justify;">
                                    RESUMO DE IMPOSTOS: </p>
                            </div>
                            <div class="col-8">
                                <!--<table class="tabela table border-0 table-hover" style="font-size: 7pt; font-family: 'Noto Sans', sans-serif; text-align: justify;">
                                    <thead style="font-weight: 600; color: #0000000d;">
                                        <tr>
                                            <td style="width: 10rem;">DESIGNAÇÃO</td>
                                            <td style="width: 8rem;">TAXA</td>
                                            <td>INCIDÊNCIA</td>
                                            <td>IMPOSTO</td>
                                        </tr>
                                    </thead>
                                    <tbody id="incidencia">${incidNew}</tbody>
                                </table> -->
                                <div class="col-12" style="margin-top: -15px !important">
                                    <p class="m-0 font-weight-bold" style="font-weight: 600; font-size: 7pt; font-family: 'Noto Sans', sans-serif; text-align: justify;">
                                        MODOS DE PAGAMENTO: </p>
                                </div>
                                <table class="tabela table border-0 table-hover" style="font-size: 7pt; font-family: 'Noto Sans', sans-serif; text-align: justify;">
                                    <thead style="font-weight: 600; color: #0000000d;">
                                        <tr>
                                            <td style="width: 10rem;">DESCRIÇÃO</td>
                                            <td style="width: 8rem;">TOTAL</td>
                                            <td>INFORMAÇÃO ADICIONAL</td>
                                        </tr>
                                    </thead>
                                    <tbody id="tabelaModoPagamentoDocumento">
                `;
            const dataModoPagamento = docData["modoPagamento"];

            console.log("PAYMENT MOOD: ", docData["modoPagamento"]);
            let row = "";
            for (var key in dataModoPagamento) {
                row += `
                    <tr>
                        <td>${dataModoPagamento[key]['nomeMp']}</td>
                        <td>${dataModoPagamento[key]['valor'].replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</td>
                        <td></td>
                    </tr>`;
                footerSectionHTML += row;
                row = '';
            }

            footerSectionHTML += `
                                    </tbody>
                                </table>
                                <div class="col-12">
                                    <p class="m-0 font-weight-bold" style="font-weight: 600; font-size: 7pt; font-family: 'Noto Sans', sans-serif; text-align: justify;">
                                        COORDENADAS BANCÁRIAS: </p>
                                </div>
                                <table class="tabela table border-0 table-hover" style="font-size: 7pt; font-family: 'Noto Sans', sans-serif; text-align: justify;">
                                    <thead style="font-weight: 600; color: #0000000d;">
                                        <tr>
                                            <td style="width: 10rem;">BANCO</td>
                                            <td style="width: 8rem;">NÚMERO DA CONTA</td>
                                            <td>IBAN</td>
                                        </tr>
                                    </thead>
                                    <tbody id="banco_banco">
                                    
                                </tbody>
                                </table>
                            </div>
                            <div class="col-4">
                                <table class="table border-0 table-hover table-striped" style="font-size: 7pt; font-family: 'Noto Sans', sans-serif; text-align: justify;">
                                    <tr>
                                        <td>MERCADORIAS/SERVIÇOS:</td>
                                        <td style="text-align: right;" id="mercadoriaServicoDocumento">${docData['outrosDocumento']['mercadoriaServicoDocumento']}</td>
                                    </tr>
                                    <tr>
                                        <td>DESCONTO GLOBAL:</td>
                                        <td style="text-align: right;" id="descontoGlobalDocumento">${docData['outrosDocumento']['descontoGlobalDocumento']}</td>
                                    </tr>
                                    <tr>
                                        <td>LÍQUIDO:</td>
                                        <td style="text-align: right;" id="totalLiquidoDocumento">${docData['outrosDocumento']['totalLiquidoDocumento']}</td>
                                    </tr>
                                    <tr>
                                        <td>IMPOSTO IVA:</td>
                                        <td style="text-align: right;" id="impostoIvaDocumento">${docData['outrosDocumento']['impostoIvaDocumento']}</td>
                                    </tr>
                                    <tr>
                                        <td>RETENÇÃO 0,00%:</td>
                                        <td style="text-align: right;" id="retencaoDocumento">${docData['outrosDocumento']['retencaoDocumento']}</td>
                                    </tr>
                                    <tr>
                                        <td>TOTAL DO DOCUMENTO:</td>
                                        <td style="text-align: right;" id="totalDocumento">${docData['outrosDocumento']['totalDocumento']}</td>
                                    </tr>
                                </table>
                                <div class="col-12">
                                    <p id="paragrafoProforma" class="m-0" style="color: #8F8F8F; font-size: 5pt; font-family: 'Noto Sans', sans-serif; text-align: justify;">
                                        Este Documento é válido por oito dias. Valor de Referência para
                                        Luanda e arredores, restantes provincias a negociar. Garantia: Suporte contínuo
                                        enquato
                                        durar a vigência do contracto de prestação de serviço.
                                        Exclusões: Estão excluídos desta proposta, Serviços adicionais que carecem de
                                        concertação prévia antes de serem executados, serviços de manutenção a
                                        infraestrutura de
                                        rede do cliente e ou de computadores que tenha apresentado avarias no seu
                                        funcionamento.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </section>
                </footer>
            `;

            return footerSectionHTML;
        }

        function closeDoc(current, totalPaginas) {
            const paginateSectionHTML = `
                        <small class="d-flex justify-content-end mt-auto" style="top: 95%; right: 3rem; position: absolute;font-size: 6pt;">
                            ${current} de ${totalPaginas}
                        </small>
                    </div>
                </div>
            `;
            return paginateSectionHTML;
        }

        $.ajax({
            url: "includes/read/configuracao.inc.php",
            type: "post",
            dataType: "json",
            success: function(data) {
                docData["configuracao"] = data;
                // logotipoDocumento.src = "./images/logo/" 
                docData["configuracao"]["logotipoDocumento"] = data[0]['valor'];
                // enderecoDocumento.innerText = data[3]['valor'];
                docData["configuracao"]["enderecoDocumento"] = data[3]['valor'];
                // telefoneDocumento.innerText = data[4]['valor'];
                docData["configuracao"]["telefoneDocumento"] = data[4]['valor'];
                // emailDocumento.innerText = data[5]['valor'];
                docData["configuracao"]["emailDocumento"] = data[5]['valor'];
                // nifDocumento.innerText = data[6]['valor'];
                docData["configuracao"]["nifDocumento"] = data[6]['valor'];
                // websiteDocumento.innerText = data[7]['valor'];
                docData["configuracao"]["websiteDocumento"] = data[7]['valor'];
            }
        });

        function codigoDocumento(codigo, tipoDocumento) {
            $.ajax({
                url: "includes/read/queryCodigoDocumento.inc.php",
                type: "post",
                dataType: "json",
                data: {
                    codigo: codigo.split("/")[1],
                    tipoDocumento: tipoDocumento
                },
                success: function(data) {
                    docData['codDocumento'] = data;
                    $.ajax({
                        url: "includes/read/queryDocumentoModoPagamento.inc.php",
                        type: "post",
                        dataType: "json",
                        data: {
                            idDocumento: data[0]['idDocumento'],
                        },
                        success: function(data) {
                            docData["modoPagamento"] = data;
                            let row = "";
                            for (var key in data) {
                                row += `
                                <tr>
                                    <td>${data[key]['nomeMp']}</td>
                                    <td>${data[key]['valor'].replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</td>
                                    <td></td>
                                </tr>`;
                            }
                            $("#tabelaModoPagamentoDocumento").html(row);
                        }
                    });

                    $.ajax({
                        url: "includes/read/queryDocumentoFac.inc.php",
                        type: "post",
                        dataType: "json",
                        data: {
                            codigo: data[0]['idDocumento'],
                            idTipoDoc: 1
                        },
                        success: function(data) {
                            console.log("Linhas: ", data);
                            docData['linhaDocumento'] = data;

                            console.log("AAAAAAAAVIIIRRRRRRR: ", data[0]);
                            let row = "";
                            // agrupar () { 

                                // var incideNOR = 0;
                                // var ipostoNOR = 0;
                                // var incideRED = 0;
                                // var ipostoRED = 0;
                                // var incideICB = 0;
                                // var ipostoICB = 0;
                                // var incideISE = 0;
                                // var ipostoISE = 0;
                                // var descrNOR = '';
                                // var descrRED = '';
                                // var descrICB = '';
                                // var descrISE = '';
                                // for (var key in data) {
                                // const total = parseFloat(data[key]['total']);
                                // const entregue = parseFloat(data[key]['entregue']);
                                // const diferenca = total - entregue;
                                // row += `
                                //     <tr>
                                //     <td>${data[key]['codigoDocumento']}</td>
                                //     <td>${data[key]['nomeTd']}</td>
                                //     <td>${data[key]['dataDoc']}</td>
                                //     <td>${parseFloat(data[key]['entregueDocRelac']).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</td>
                                //     <td>${parseFloat(data[key]['faltaDocRelac']).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</td>
                                //     <td>${parseFloat(data[key]['total']).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</td>
                                //     <td>${data[key]['nomePp']}</td>
                                //     </tr>
                                //     `;
    
                                // if (data[key]['idImposto'] == 1) {
                                //     incideNOR = data[key]['totalAd'] + incideNOR;
                                //     ipostoNOR = data[key]['imposto'] + ipostoNOR;
                                //     descrNOR = data[key]['nome'];
                                // } else if (data[key]['idImposto'] == 2) {
                                //     incideRED = data[key]['totalAd'] + incideRED;
                                //     ipostoRED = data[key]['imposto'] + ipostoRED;
                                //     descrRED = data[key]['nome'];
                                // } else if (data[key]['idImposto'] == 3) {
                                //     incideICB = data[key]['totalAd'] + incideICB;
                                //     ipostoICB = data[key]['imposto'] + ipostoICB;
                                //     descrICB = data[key]['nome'];
                                // } else if (data[key]['idImposto'] == 4) {
                                //     incideISE = data[key]['totalAd'] + incideISE;
                                //     ipostoISE = data[key]['imposto'] + ipostoISE;
                                //     descrISE = data[key]['nome'];
                                // }
                                // }
                                // $("#tabelaDocumento").html(row);
                                // let incidNew = '';
                                // if (descrNOR != '') {
                                //     incidNew = `<tr>
                                //             <td>${descrNOR}</td>
                                //             <td>14%</td>
                                //             <td>${parseFloat(incideNOR).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</td>
                                //             <td>${parseFloat(ipostoNOR).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</td>
                                //         </tr>`;
                                // }
                                // if (descrRED != '') {
                                //     incidNew += `<tr>
                                //                 <td>${descrRED}</td>
                                //                 <td>7%</td>
                                //                 <td>${parseFloat(incideRED).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</td>
                                //                 <td>${parseFloat(ipostoRED).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</td>
                                //             </tr>`;
                                // }
                                // if (descrICB != '') {
                                //     incidNew += `<tr>
                                //                 <td>${descrICB}</td>
                                //                 <td>5%</td>
                                //                 <td>${parseFloat(incideICB).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</td>
                                //                 <td>${parseFloat(ipostoICB).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</td>
                                //             </tr>`;
                                // }
                                // if (descrISE != '') {
                                //     incidNew += `<tr>
                                //                 <td>${descrISE}</td>
                                //                 <td>0%</td>
                                //                 <td>${parseFloat(incideISE).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</td>
                                //                 <td>${parseFloat(ipostoICB).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</td>
                                //             </tr>`;
                                // }
    
                                // $('#incidencia').html(incidNew);
                            // }
                        }
                    });
                }
            }).done(function(data) {
                $.ajax({
                    url: "includes/read/queryDocumento.inc.php",
                    type: "post",
                    dataType: "json",
                    data: {
                        idDocumento: data[0]['idDocumento'],
                    },
                    success: function(data) {

                        docData['outrosDocumento'] = data;
                        // let marcaDagua = document.querySelector('.marca-dagua');
                        docData['outrosDocumento']['estadoEmissao'] = data[0]['estadoEmissao'];
                        if (data[0]['estadoEmissao'] == 0) {
                            // marcaDagua.style.setProperty('--content', '"Anulado"');
                        } else if (data[0]['estadoEmissao'] == 1) {
                            // marcaDagua.style.setProperty('--content', '""');
                        } else if (data[0]['estadoEmissao'] == 2) {
                            // marcaDagua.style.setProperty('--content', '"Bloqueado"');
                        }
                        // codDocumento.innerText = data[0]['codigoDocumento'];
                        docData['outrosDocumento']['codDocumento'] = data[0]['codigoDocumento'];
                        // nomeTipoDocumento.innerText = data[0]['nomeTd'];
                        docData['outrosDocumento']['nomeTipoDocumento'] = data[0]['nomeTd'];
                        // clienteDocumento.innerText = data[0]['nomeE'].toUpperCase();
                        docData['outrosDocumento']['clienteDocumento'] = data[0]['nomeE'].toUpperCase();
                        // moradaDocumento.innerText = data[0]['moradaE'];
                        docData['outrosDocumento']['moradaDocumento'] = data[0]['moradaE'];
                        // dataEmissaoDocumento.innerText = data[0]['dataDocumento'];
                        docData['outrosDocumento']['dataEmissaoDocumento'] = data[0]['dataDocumento'];
                        // dataVencimentoDocumento.innerText = data[0]['dataDocumento'];
                        docData['outrosDocumento']['dataVencimentoDocumento'] = data[0]['dataDocumento'];
                        // modoPagamentoDocumento.innerText = data[0]['nomePp'];
                        docData['outrosDocumento']['modoPagamentoDocumento'] = data[0]['nomePp'];
                        // nifDocumento.innerText = data[0]['nifE'];
                        docData['outrosDocumento']['nifDocumento'] = data[0]['nifE'];

                        // mercadoriaServicoDocumento.innerText = data[0]['total'] == null ? parseFloat(0).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ") : parseFloat(data[0]['total']).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ");

                        docData['outrosDocumento']['mercadoriaServicoDocumento'] = data[0]['total'] == null ? parseFloat(0).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ") : parseFloat(data[0]['total']).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ");

                        // descontoGlobalDocumento.innerText = data[0]['descontoGlobal'] == null ? parseFloat(0).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ") : parseFloat(data[0]['descontoGlobal']).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ");

                        docData['outrosDocumento']['descontoGlobalDocumento'] = data[0]['descontoGlobal'] == null ? parseFloat(0).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ") : parseFloat(data[0]['descontoGlobal']).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ");

                        // totalLiquidoDocumento.innerText = data[0]['totalLiquido'] == null ? parseFloat(0).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ") : parseFloat(data[0]['totalLiquido']).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ");

                        docData['outrosDocumento']['totalLiquidoDocumento'] = data[0]['totalLiquido'] == null ? parseFloat(0).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ") : parseFloat(data[0]['totalLiquido']).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ");

                        // impostoIvaDocumento.innerText = data[0]['imposto'] == null ? parseFloat(0).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ") : parseFloat(data[0]['imposto']).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ");

                        docData['outrosDocumento']['impostoIvaDocumento'] = data[0]['imposto'] == null ? parseFloat(0).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ") : parseFloat(data[0]['imposto']).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ");

                        // console.log('GETTING: ', data[0]);

                        // retencaoDocumento.innerText = data[0]['retencao'] == null ? parseFloat(0).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ") : parseFloat(data[0]['retencao']).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ");

                        docData['outrosDocumento']['retencaoDocumento'] = data[0]['retencao'] == null ? parseFloat(0).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ") : parseFloat(data[0]['retencao']).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ");


                        // totalDocumento.innerText = data[0]['total'] == null ? parseFloat(0).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ") : parseFloat(data[0]['total']).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ");

                        docData['outrosDocumento']['totalDocumento'] = null ? parseFloat(0).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ") : parseFloat(data[0]['total']).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ");

                        // docData['outrosDocumento']['totalDocumento'] = data[0]["natureza"];


                        let documentParts = [];

                        const dataLine = docData["linhaDocumento"];
                        const totalLinhas = docData["linhaDocumento"].length;
                        const linhasPorPagina = 24;
                        const totalPaginas = Math.ceil(totalLinhas / linhasPorPagina);

                        for (let i = 0; i < totalPaginas; i++) {
                            const start = i * linhasPorPagina;
                            const end = start + linhasPorPagina;
                            const pageData = dataLine.slice(start, end);

                            documentParts.push(openDoc());
                            documentParts.push(buildHeaderSection());

                            if (i === 0) {}

                            documentParts.push(buildStoreUserSection());
                            documentParts.push(buildProductSection(pageData));

                            if (i + 1 === totalPaginas) {
                                documentParts.push(buildFooter());
                            }
                            documentParts.push(closeDoc(i + 1, totalPaginas));
                        }

                        console.log("AAAAQUIIII: ", dataLine);

                        mainDoc.innerHTML = documentParts.join("");

                        let marcaDagua = document.querySelectorAll('.marca-dagua');
                        marcaDagua.forEach(mH20 => {
                            if (docData['outrosDocumento']['estadoEmissao'] == 0) {
                                mH20.style.setProperty('--content', '"Anulado"');
                            } else if (docData['outrosDocumento']['estadoEmissao'] == 1) {
                                mH20.style.setProperty('--content', '""');
                            } else if (docData['outrosDocumento']['estadoEmissao'] == 2) {
                                mH20.style.setProperty('--content', '"Bloqueado"');
                            }
                        });

                        if (data[0]["natureza"] === "facturaProforma" || data[0]["natureza"] === "facturaProformaC") {
                            paragrafoProforma.style.display = "block";
                        } else {
                            paragrafoProforma.style.display = "none";
                        }
                    }
                })

                funcaoSelect("../pos/includes/select.inc.php", "post", "json", "caixabanco", function success(data) {
                        if (Array.isArray(data)) {
                            console.log(data);
                            console.log('data de entrada');

                            for (var i = 0; i < data.length; i++) {
                                if(data[i]['idTipoCaixaBanco'] == 2){
                                    var ncc = data[i]['numeroconta'] ?? '';
                                    var ibb = data[i]['iban'] ?? '';
                                $('#banco_banco').append(`
                                                <tr>
                                                    <td>${data[i]['descricao']}</td>
                                                    <td>${ncc}</td>
                                                    <td>${ibb}</td>
                                                </tr>
                            `)
                                }
                            }

                        }
                    }, function error(data) {

                    }, function done(data) {

                    });
            });

            function funcaoSelect(url, type, dataType, tabela, success, error, done) {
                $.ajax({
                    url: url,
                    type: type,
                    dataType: dataType,
                    data: {
                        tabela: tabela
                    },
                    success: function(data) {
                        success(data);
                    },
                    error: function(data) {
                        error(data);
                    }
                }).done(function(data) {
                    done(data);
                });
            }
        }
    </script>
</body>

</html>