<?php include('./header.php'); ?>
<style type="text/css">
  .logo img {
    width: 150px;
  }

  .container .form-outer {
    width: 100%;
    overflow: hidden;
  }

  .form-outer .formulario {
    display: flex;
    width: 400%;
  }

  .form-outer .formulario .page {
    width: 25%;
    transition: margin-left 0.3s ease-in-out;
  }

  .form-outer .formulario .page .field {
    display: flex;
  }

  .form-outer .formulario .page .field button:hover {
    background-color: #66009f;
    border-color: #66009f;
  }

  .form-outer .formulario .page .field button {
    background-color: #560085;
    border-color: #560085;
  }

  .formulario .page .btns button.prev {
    margin-right: 3px !important;
    font-size: 17px;
  }

  .formulario .page .btns button.next {
    margin-left: 3px !important;
  }

  .container .progress-barra {
    display: flex;
    justify-content: space-between;
  }

  .container .progress-barra .step {
    position: relative;
    text-align: center;
    width: 100%;
    display: flex;
    align-items: center;
    justify-content: center;
    flex-direction: column;
  }

  .progress-barra .step p {
    font-size: 14px;
    font-weight: 500;
    color: #666;
    margin-bottom: 8px;
    transition: 0.2s;
  }

  .progress-barra .step p.active {
    color: #560085;
  }

  .progress-barra .step .bullet {
    position: relative;
    height: 35px;
    width: 35px;
    border: 2px solid #666;
    display: inline-block;
    border-radius: 50%;
    transition: 0.2s;
    display: flex;
    align-items: center;
    justify-content: center;
  }

  .progress-barra .step .bullet.active {
    border-color: #560085;
    background: #560085;
  }

  .progress-barra .step .bullet span {
    font-weight: 500;
    position: absolute;
    left: 50%;
    transform: translateX(-50%);
  }

  .progress-barra .step .bullet.active span {
    display: none;
  }

  .progress-barra .step:last-child .bullet:before,
  .progress-barra .step:last-child .bullet:after {
    display: none;
  }

  .progress-barra .step .bullet:before,
  .progress-barra .step .bullet:after {
    position: absolute;
    content: '';
    right: -14.35rem;
    height: 3px;
    width: 14rem;
    background: #666;
  }

  .progress-barra .step .bullet.active:after {
    background: #560085;
    transform: scaleX(0);
    transform-origin: left;
    animation: animate 0.3s linear forwards;
  }

  @keyframes animate {
    100% {
      transform: scaleX(1);
    }
  }

  .progress-barra .step .check {
    position: absolute;
    font-size: 15px;
    color: #666;
    display: none;
  }

  .progress-barra .step .check.active {
    display: block;
    color: #fff;
  }
</style>

<body class="hold-transition layout-top-nav">
  <div class="wrapper">
    <div class="preloader flex-column justify-content-center align-items-center">
    </div>
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
      <!-- Content Header (Page header) -->
      <div class="content-header">
        <div class="container-fluid">
        </div><!-- /.container-fluid -->
      </div>
      <!-- /.content-header -->

      <section class="content">
        <div class="container-fluid">
          <div class="row">
            <!-- SELECT2 EXAMPLE -->
            <div class="col-md-12">
              <div class="card card-default">
                <div class="card-body button-nav">
                  <div class="row float-right">
                    <div class="col-md-12">
                      <button class="btn btn-opcao" id="btn-password" disabled>Redefinir senha</button>
                      <button class="btn btn-opcao" id="btn-preview" disabled>Pré-visualizar</button>
                      <button class="btn btn-opcao">Importar</button>
                      <button class="btn btn-opcao botao-activo" id="btn">Novo Usuário</button>
                    </div>
                  </div>
                  <!-- /.row -->
                </div>
                <!-- /.card-body -->
              </div>
            </div>
            <div class="col-md-12">
              <div class="card card-default">
                <div class="card-header">
                  <h3 class="card-title">Listagem de Usuários</h3>
                  <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                      <i class="fas fa-minus"></i>
                    </button>
                    <button type="button" class="btn btn-tool" data-card-widget="remove">
                      <i class="fas fa-times"></i>
                    </button>
                  </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                  <table id="tabelaUsuario" class="table table-bordered table-striped" style="line-height: 0.8;">
                    <thead>
                      <tr style="text-align: center;">
                        <th title="Identificador do Usuário">Ref. Usuário</th>
                        <th title="Nome">Nome</th>
                        <th title="Género (Masculino, Feminino)">Género</th>
                        <th title="Bilhete de Identidade">B.I</th>
                        <th title="E-mail">E-mail</th>
                        <th title="Nome de Usuário">Nome de Usuário</th>
                        <th title="Tipo de Usuário">Tipo de Usuário</th>
                        <th title="Opções"><i class="fa-solid fa-screwdriver-wrench"></i></th>
                      </tr>
                    </thead>
                    <tbody id="corpoTabela" style="text-align: center;">

                    </tbody>
                  </table>
                </div>
                <!-- /.card-body -->
                <div class="card-footer">
                  Listagem dos Usuários.
                </div>
              </div>
            </div>
          </div>
          <!-- /.card -->
        </div>
        <!-- /.container-fluid -->
      </section>
      <div class="modal fade" id="modal-documento">
        <div class="modal-dialog modal-xl">
          <div class="modal-content">
            <div class="modal-header">
              <div class="container">
                <div class="progress-barra">
                  <div class="step">
                    <p style="margin: 0;">Formulário de Usuário</p>
                  </div>
                  <button type="button" class="close" data-dismiss="modal" aria-label="close">
                    <small aria-hidden="true">
                      <small class="fas fa-close"></small>
                    </small>
                  </button>  
                </div>
              </div>
            </div>
            <div class="modal-body">
              <div class="container">
                <div class="card-body form-outer" style="padding: 0;">
                  <div class="formulario">
                    <div class="page slidePage">
                      <div class="row">
                        <div class="col-md-12">
                          <h5 style="margin-bottom: 1rem; justify-content: center;"><span id="doOpcao"></span> - <span id="codigo"></span></h5>
                          <div class="row">
                            <div class="col-md-2" style="text-align: -webkit-center;">
                              <div class="form-group margem">
                                <div class="wrapper-image">
                                  <div class="image-container">
                                    <i class="fas fa-image"></i>
                                  </div>
                                  <label for="file" class="camera-icon">
                                    <i class="fas fa-camera"></i>
                                  </label>
                                  <input type="file" id="file" name="file" accept="image/*" hidden>
                                </div>
                              </div>
                            </div>
                            <div class="col-md-2"></div>
                            <div class="col-md-4"></div>
                            <div class="col-md-4">
                              <div class="form-group" style="margin-top: .4rem;">
                                <small>Mensagem de erro</small>
                                <div class="custom-control custom-switch">
                                  <input type="checkbox" class="custom-control-input" name="estado" id="estado" value="0">
                                  <label class="custom-control-label" for="estado">Estado - Activo</label>
                                </div>
                              </div>
                            </div>
                            <div class="col-md-4">
                              <div class="form-group" style="margin-bottom: 0;">
                                <small class="required">Nome Completo</small>
                                <input type="text" class="form-control" id="nome" name="nome" placeholder="Nome Completo" title="Nome Completo" required>
                                <small>Mensagem de erro</small>
                              </div>
                              <div class="form-group" style="margin-bottom: 0;">
                                <small class="required">Nome de Usuário</small>
                                <input type="text" class="form-control" id="nomeUsuario" name="nomeUsuario" placeholder="Nome de Usuário" title="Nome de Usuário" required>
                                <small>Mensagem de erro</small>
                              </div>
                              <div class="form-group margem">
                                <small class="required">Terminais</small>
                                <select class="select2" multiple="multiple" id="idTerminal" data-placeholder="Selecione um ou mais terminais" style="width: 100%;">
                                </select>
                                <small>Mensagem de erro</small>
                              </div>
                            </div>
                            <div class="col-md-4">
                              <div class="form-group" style="margin-bottom: 0;">
                                <small class="required">E-mail</small>
                                <input type="text" class="form-control" id="email" name="email" placeholder="E-mail" title="E-mail" required>
                                <small>Mensagem de erro</small>
                              </div>
                              <div class="form-group" style="margin-bottom: 0;">
                                <small class="required">Bilhete de Identidade</small>
                                <input type="text" class="form-control" id="bi" name="bi" placeholder="Bilhete de Identidade" title="Nº Bilhete de Indentidade" required>
                                <small>Mensagem de erro</small>
                              </div>
                              <div class="form-group" style="margin-bottom: 0;">
                                <small class="not-required">Terminal</small>
                                <select class="form-control select2" style="width: 100%;" id="terminal" name="terminal" disabled='disabled'>
                                  <option value='0'>Nenhum Terminal Selecionado</option>
                                </select>
                                <small>Mensagem de erro</small>
                              </div>
                            </div>
                            <div class="col-md-4">
                              <div class="form-group" style="margin-bottom: 0;">
                                <small class="required">Género</small>
                                <select class="form-control select2" style="width: 100%;" id="genero" name="genero">
                                  <option value="0">Selecione um género</option>
                                  <option value="Masculino">Masculino</option>
                                  <option value="Feminino">Feminino</option>
                                </select>
                                <small>Mensagem de erro</small>
                              </div>
                              <div class="form-group" style="margin-bottom: 0;">
                                <small class="required">Tipo de Usuário</small>
                                <select class="form-control select2" style="width: 100%;" id="idTipoUsuario" name="idTipoUsuario">
                                  <option value="0">Selecione um Tipo de Usuário</option>
                                </select>
                                <small>Mensagem de erro</small>
                              </div>
                            </div>
                          </div>
                        </div>
                        <div class="col-md-12" style=" bottom: 0; padding-top: 14px;">
                          <div class="form-group margem">
                            <small>Mensagem de erro</small>
                            <div class="form-group field btns">
                              <button class="btn btn-block btn-primary submit next" style="margin-top: 0;">
                                Gravar Usuário
                              </button>
                            </div>
                          </div>
                        </div>
                      </div>

                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="modal-footer">
              <div class="col-md-12" id="footerPagamento" style="opacity: 0;">
                <h4 style="display: flex; align-items: center; justify-content: space-between;"><span id="totalEntregue">ENTREGUE</span><span id="entregueSpan">0,00 Kzs</span></h4>
                <h4 style="display: flex; align-items: center; justify-content: space-between;"><span class="text-danger" id="totalText">TOTAL</span><span class="text-danger" id="totalSpan">0,00 Kzs</span></h4>
              </div>
            </div>
          </div>
          <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
      </div>
      <div class="modal fade" id="modal-cliente">
        <div class="modal-dialog modal-xl">
          <div class="modal-content">
            <div class="modal-header">
              <h4 class="modal-title">Entidades</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <table id="tabelaCliente" class="table table-hover table-bordered table-striped" style="line-height: 0.8;">
                <thead>
                  <tr style="text-align: center;">
                    <th title="Identificador da Entidade">Ref. Entidade</th>
                    <th title="Nome">Nome</th>
                    <th title="Nome Comercial">Nome Comercial</th>
                    <th title="Bilhete de Identidade do Cliente">B.I</th>
                    <th title="NIF do Cliente">NIF</th>
                    <th title="Localidade do Cliente">Localidade</th>
                    <th title="Data de Nascimento do Cliente">Data Nasc.</th>
                    <th title="Morada do Cliente">Morada</th>
                    <th title="Tipo">Tipo</th>
                    <th title="Estado do Cliente">Estado</th>
                  </tr>
                </thead>
                <tbody style="text-align: center;">
                </tbody>
              </table>
            </div>
            <div class="modal-footer justify-content-between">
              <button type="button" class="btn btn-default" data-dismiss="modal">Cancelar</button>
              <button type="button" class="btn btn-primary">Confirmar</button>
            </div>
          </div>
          <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
      </div>
      <div class="modal fade" id="modal-artigo">
        <div class="modal-dialog modal-xl">
          <div class="modal-content">
            <div class="modal-header">
              <h4 class="modal-title">Artigos</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <table id="tabelaArtigoListagem" class="table table-hover table-bordered table-striped" style="line-height: 0.8;">
                <thead>
                  <tr style="text-align: center;">
                    <th title="Referência">Referência</th>
                    <th title="Descrição do Artigo">Descrição</th>
                    <th title="Família">Família</th>
                    <th title="Preço do Artigo (S/Imp)">Preço (S/Imp)</th>
                    <th title="Preço do Artigo (C/Imp)">Preço (C/Imp)</th>
                    <th title="Qtd. Stock">Qtd. Stock</th>
                  </tr>
                </thead>
                <tbody style="text-align: center;">
                </tbody>
              </table>
            </div>
            <div class="modal-footer justify-content-between">
              <button type="button" class="btn btn-default" data-dismiss="modal">Cancelar</button>
              <button type="button" class="btn btn-primary">Confirmar</button>
            </div>
          </div>
          <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
      </div>
    </div>
    <div class="modal fade" id="modal-updateUsuario">
      <div class="modal-dialog modal-xl">
        <div class="modal-content">
          <div class="modal-header" style="padding: 0.5rem;">
            <h3 class="card-title p-3">Usuário: <span id="nomeModal"></span></h3>
          </div>
          <div class="modal-body" style="padding-bottom: 0px;">
            <div class="row">
              <div class="col-md-12">
                <form name="tabelaInfo">
                  <table name="tabelaInfo" class="table table-sm table-bordered" style="min-width: 100%;
                      max-width: 100%;">
                    <tr name="linhaItem">
                      <td style="width: 400px;">
                        <div class="form-group margem wrapper-info" style="margin-top: 1rem;">
                          <div class="caixa image-info" id="imagemInfo">
                            <i class="fas fa-image"></i>
                          </div>
                        </div>
                      </td>
                      <td style="padding: 20px 0px 0px 10px;">
                        <p>Ref. do Usuário: <span id="codigoInfo"></span></p>
                        <p>Nome: <span id="nomeInfo"></span></p>
                        <p>Género: <span id="generoInfo"></span></p>
                        <p>Bilhete de identidade: <span id="biInfo"></span></p>
                        <p>E-mail: <span id="emailInfo"></span></p>
                        <p>Nome usuário: <span id="nomeUsuarioInfo"></span></p>
                        <p>Tipo usuário: <span id="tipoUsuarioInfo"></span></p>
                      </td>
                    </tr>
                  </table>
                </form>
              </div>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Fechar</button>
          </div>
        </div>
        <!-- /.modal-content -->
      </div>
      <!-- /.modal-dialog -->
    </div>
    <!-- /.content-wrapper -->
    <?php include('footer.php'); ?>
</body>

</html>
<script src="./../pos/javascript/function.js"></script>
<script>
  let idCliente;
  let valorLinha;
  let totalDoc;
  let pendenteVerify;
  let totalImposto = [];
  let dataHoraFormatada;
  let resizedImage;
  let linhaUsuario;

  funcaoAutoIncrement('../pos/includes/autoIncrement.inc.php', 'post', 'json', 'dbbuesimples', 'usuario', 'lastId', function success(data) {
    console.log("Ver autoincrmeent: ", data);

  }, function error(data) {

  }, function done(data) {

  });


  let btnOpcao = document.querySelectorAll(".btn-opcao");
  for (let i = 0; i < btnOpcao.length; i++) {
    btnOpcao[i].addEventListener("click", function() {
      for (let j = 0; j < btnOpcao.length; j++) {
        btnOpcao[j].classList.remove("botao-activo");
      }
      btnOpcao[i].classList.add("botao-activo");
    });
  }

  $(document).on("change", "#estado", function(e) {
    e.preventDefault();
    var labelEstado = document.querySelector("label[for='estado']");
    if (estado.checked == true) {
      estado.value = 1;
      labelEstado.innerText = "Estado - Activo";
    } else {
      estado.value = 0;
      labelEstado.innerText = "Estado - Inactivo";
    }
  });

  $(document).ready(function() {
    $(function() {
      //Initialize Select2 Elements
      $('.select2').select2()

      //Initialize Select2 Elements
      $('.select2bs4').select2({
        theme: 'bootstrap4'
      })
    });
  });

  $(document).ready(function() {
    const img_input = document.querySelector("#file");
    img_input.addEventListener("change", function() {
      const reader = new FileReader();
      reader.addEventListener("load", () => {
        const imgElement = document.createElement("img");
        imgElement.src = reader.result;
        imgElement.onload = function(e) {
          const canvas = document.createElement("canvas");
          const MAX_WIDTH = 400;
          const scaleSize = MAX_WIDTH / e.target.width;
          canvas.width = MAX_WIDTH;
          canvas.height = e.target.height * scaleSize;
          const ctx = canvas.getContext("2d");
          ctx.drawImage(e.target, 0, 0, canvas.width, canvas.height);

          const srcEncoded = ctx.canvas.toDataURL(e.target, "image/jpeg");
          resizedImage = urlToFile(srcEncoded);
        }

        const uploaded_image = reader.result;
        document.querySelector(".image-container").style.backgroundImage = `url(${uploaded_image})`;
      });
      reader.readAsDataURL(this.files[0]);
      document.querySelector(".image-container").querySelector("i").style.display = "none";
    });
  });

  $(document).ready(function() {
    $.ajax({
      url: "includes/read/codigoDocumento.inc.php",
      type: "post",
      dataType: "json",
      data: {
        codigo: 2
      },
      success: function(data) {
        codigo.innerText = "<?php echo date("Y"); ?>" + "/" + data[0]["contador"];
      }
    });
  });


  function actualizarDataHora() {
    const dataActual = new Date();

    // Obtenha o ano, mês, dia, hora e minutos
    const ano = dataActual.getFullYear();
    const mes = formatoDoisDigitos(dataActual.getMonth() + 1);
    const dia = formatoDoisDigitos(dataActual.getDate());
    const hora = formatoDoisDigitos(dataActual.getHours());
    const minutos = formatoDoisDigitos(dataActual.getMinutes());
    dataHoraFormatada = `${ano}-${mes}-${dia}T${hora}:${minutos}`;

    function formatoDoisDigitos(valor) {
      return valor < 10 ? `0${valor}` : valor;
    }
  }

  setInterval(actualizarDataHora, 1000);
  // Função para formatar valores com dois dígitos
  actualizarDataHora();


  $(document).on('click', '#tabelaUsuario tbody tr', function() {
    var isSelected = $(this).hasClass('selected');
    let btnPreview = document.querySelector("#btn-preview");
    let btnPassword = document.querySelector("#btn-password");
    $('#tabelaUsuario tbody tr').removeClass('selected');
    if (!isSelected) {
      $(this).addClass('selected');
      btnPreview.removeAttribute("disabled");
      btnPassword.removeAttribute("disabled");
    } else {
      btnPreview.setAttribute("disabled", "disabled");
      btnPreview.classList.remove("botao-activo");
      btnPassword.setAttribute("disabled", "disabled");
      btnPassword.classList.remove("botao-activo");
    }
  });
</script>
<script>
  /*import {
    initializeApp
  } from 'https://www.gstatic.com/firebasejs/10.1.0/firebase-app.js'
  import {
    getAnalytics
  } from 'https://www.gstatic.com/firebasejs/10.1.0/firebase-analytics.js'
  import {
    getAuth
  } from 'https://www.gstatic.com/firebasejs/10.1.0/firebase-auth.js'
  import {
    getFirestore,
    collection,
    addDoc,
    getDocs
  } from 'https://www.gstatic.com/firebasejs/10.1.0/firebase-firestore.js'

  const firebaseConfig = {
    apiKey: "AIzaSyAYl5f_OOc_aosK9sURTixa1tCckK6lpMY",
    authDomain: "serra-trucks-d2fe5.firebaseapp.com",
    projectId: "serra-trucks-d2fe5",
    storageBucket: "serra-trucks-d2fe5.appspot.com",
    messagingSenderId: "698670207304",
    appId: "1:698670207304:web:c117cd4d8d8f1816c0e37d",
    measurementId: "G-W6ZYHPBKPF"
  };

  const app = initializeApp(firebaseConfig);
  const db = getFirestore(app);*/

  let linha;
  $(document).ready(function() {
    funcaoSelect("../pos/includes/select.inc.php", "post", "json", "tipoUsuario", function success(data) {
      let select = "";
      select += "<option value='0'>Selecione um Tipo de Usuario</option>";
      for (var key in data) {
        select += "<option value=" + data[key]['idTipoUsuario'] + ">" + data[key]['nome'] + "</option>";
      }
      $("#idTipoUsuario").html(select);
    }, function error(data) {

    }, function done(data) {});
  });

  function updateLinha(linha) {
    $.ajax({
      url: "includes/read/queryUser.inc.php",
      type: "post",
      dataType: "json",
      data: {
        idUsuario: linha[0].innerText,
      },
      success: function(data) {
        for (var key in data) {
          linha[1].innerText = data[key]["nome"];
          linha[2].innerText = data[key]["genero"];
          linha[3].innerText = data[key]["bi"];
          linha[4].innerText = data[key]["email"];
          linha[5].innerText = data[key]["nomeUsuario"];
          linha[6].innerText = data[key]["tipoUsuario"];
        }
      }
    });
  }

  $(document).on("change", "#idTerminal", function(e) {
    if ($("#idTerminal").val().length != 0) {
      let terminal = $("#idTerminal").val();
      let vector = [];

      for (let i = 0; i < $("#idTerminal").val().length; i++) {
        let valor = $("#idTerminal").val()[i];
        let texto = $("#idTerminal option[value='" + $("#idTerminal").val()[i] + "']").text();

        var opcao = {
          valor: valor,
          texto: texto
        }
        vector.push(opcao);
      }
      let valoresTerminal = "";
      for (let j = 0; j < vector.length; j++) {

        valoresTerminal += `<option value="${vector[j]["valor"]}">${vector[j]["texto"]}</option>`;
      }
      $("#terminal").html(valoresTerminal);
      if ($("#idTerminal").val().length > 1) {
        $("#terminal").removeAttr('disabled');
      } else {
        $("#terminal").attr('disabled', 'disabled');
      }
    } else {
      $("#terminal").attr('disabled', 'disabled');
      $("#terminal").html("<option value='0'>Nenhum Terminal Selecionado</option>");
    }
  });


  function insertLinha(id) {
    $.ajax({
      url: "includes/read/queryUser.inc.php",
      type: "post",
      dataType: "json",
      data: {
        idUsuario: id,
      },
      success: function(data) {
        for (var key in data) {
          var novaLinha = {
            idUsuario: data[key]["idUsuario"],
            nome: data[key]["nome"],
            genero: data[key]["genero"],
            bi: data[key]["bi"],
            email: data[key]["email"],
            nomeUsuario: data[key]["nomeUsuario"],
            tipoUsuario: data[key]["tipoUsuario"],
          };
          $('#tabelaUsuario').DataTable().row.add(novaLinha).draw(false);
        }
      }
    });
  }

  $(document).ready(function() {
    $.ajax({
      url: "includes/read/usuario.inc.php",
      type: "post",
      dataType: "json",
      success: function(data){
          console.log(data);
      }, error: function(data){
          console.log(data);
      }
    }).done(function(data) {
      $("#tabelaUsuario").DataTable({
        select: 'single',
        "aaData": data,
        "columns": [{
          data: "idUsuario"
        }, {
          data: "nome"
        }, {
          data: "genero"
        }, {
          data: "bi"
        }, {
          data: "email"
        }, {
          data: "nomeUsuario"
        }, {
          data: "tipoUsuario"
        }, {
          data: null,
          render: function(data, type, row) {
            return `
            <div id="dropdownOpcoes" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" style="display:flex; align-items: center; justify-content: space-around;"><button class="btn btn-outline-primary opcoes" style="padding: .2rem .7rem; line-height: 1; border: none;"><i class="fa-solid fa-ellipsis-vertical"></i></button></div>
            <ul aria-labelledby="dropdownOpcoes" class="dropdown-menu border-0 shadow">
              <li style="padding: 0 .4rem;"><a href="#" class="dropdown-item btn-more" style="padding: .8rem; border-radius: 5px;">Informações</a></li>
              <li style="padding: 0 .4rem;"><a href="#" class="dropdown-item btn-update" style="padding: .8rem; border-radius: 5px;">Editar</a></li>
              <li style="padding: 0 .4rem;"><a href="#" class="dropdown-item btn-delete" style="padding: .8rem; border-radius: 5px;">Eliminar</a></li>
            </ul>`;
          }
        }],
        columnDefs: [{
          targets: -1,
          orderable: false
        }],
        "responsive": true,
        "lengthChange": false,
        "autoWidth": false,
        "language": idiomaPortugues,
        lengthMenu: [
          [7, 25, 50, -1],
          [10, 25, 50, 'All']
        ],
        "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
      }).buttons().container().appendTo('#tabelaUsuario_wrapper .col-md-6:eq(0)');
    });
  });

  var idiomaPortugues = {
    buttons: {
      copy: "Copiar",
      print: "Imprimir",
      colvis: "Visibilidade"
    },
    "sProcessing": "A processar...",
    "sLengthMenu": "Mostrar _MENU_ dos registros",
    "sZeroRecords": "Sem resultados!",
    "sEmptyTable": "Tabela sem dados disponíveis",
    "sInfo": "De _START_ à _END_ de um total de _TOTAL_ registros",
    "sInfoEmpty": "De 0 à 0 de um total de 0 registros",
    "sInfoFiltered": "(filtrado de um total de _MAX_ registros)",
    "sInfoPostFix": "",
    "sSearch": "Pesquisar:",
    "sUrl": "",
    "sInfoThousands": ",",
    "sLoadingRecords": "A carregar...",
    "oPaginate": {
      "sFirst": "Primeira",
      "sLast": "Última",
      "sNext": "Seguinte",
      "sPrevious": "Anterior"
    },
    "oAria": {
      "sSortAscending": ": Activar para ordenar a coluna de forma ascendente",
      "sSortDescending": ": Activar para ordenar a coluna de forma descendente"
    }
  }

  $('#tabelaUsuario tbody').on('click', 'tr', function() {
    detalhes(this.cells[0].innerText);
  });

  function reload() {
    $('#modal-documento').modal('hide');
    resetForm();
    loadNovoId();
    let imagem = document.querySelector('.image-container');
    let iconImage = imagem.querySelector('i');

    imagem.style.backgroundImage = ``;
    iconImage.style.display = "block";
    nome.value = "";
    nome.parentElement.querySelectorAll("small")[1].style.visibility = "hidden";
    nome.className = "form-control";
    nomeUsuario.value = "";
    nomeUsuario.parentElement.querySelectorAll("small")[1].style.visibility = "hidden";
    nomeUsuario.className = "form-control";
    email.value = "";
    email.parentElement.querySelectorAll("small")[1].style.visibility = "hidden";
    email.className = "form-control";
    bi.value = "";
    bi.parentElement.querySelectorAll("small")[1].style.visibility = "hidden";
    bi.className = "form-control";

    $('#genero').val(0);
    $('#genero').select2().trigger('change');
    document.querySelector("#genero").parentElement.querySelectorAll("small")[1].style.visibility = "hidden";
    genero.classList.remove("select2-danger");

    $('#idTipoUsuario').val(0);
    $('#idTipoUsuario').select2().trigger('change');
    document.querySelector("#idTipoUsuario").parentElement.querySelectorAll("small")[1].style.visibility = "hidden";
    idTipoUsuario.classList.remove("select2-danger");

    document.querySelector(".submit").removeAttribute('disabled');

    estado.checked = true;
    estado.value = 1;
  }

  $(document).on("click", "#btn-preview", function(e) {
    e.preventDefault();
    $('#modal-updateUsuario').modal('show');
  });

  $(document).on("click", "#btn", function(e) {
    e.preventDefault();
    doOpcao.innerText = "Novo Usuário";
    reload();

    $('#modal-documento').modal('show');
    $(function() {
      //Initialize Select2 Elements
      $('.select2').select2()

      //Initialize Select2 Elements
      $('.select2bs4').select2({
        theme: 'bootstrap4'
      })
    })
    /*$('#modal-documento').modal({
      backdrop: 'static'
    }, 'show');*/
  });

  function ajax(idUsuario) {
    $.ajax({
      url: "includes/read/queryUser.inc.php",
      type: "post",
      dataType: "json",
      data: {
        idUsuario: idUsuario
      },
      success: function(data) {
        imagemInfo = document.getElementById("imagemInfo");
        img = document.querySelector(".image-info");

        imgUpdate = document.querySelector(".image-container");

        for (var key in data) {
          if (data[key]['imagem'] != null) {
            img.querySelector("i").style.display = "none";
            imagemInfo.style.backgroundImage = "url('images/usuario/" + data[key]['imagem'] + "')";
          } else {
            img.querySelector("i").style.display = "block";
            imagemInfo.style.backgroundImage = "url('images/usuario/" + data[key]['imagem'] + "')";
          }

          nomeModal.innerText = data[key]['nome'];
          codigoInfo.innerText = data[key]['idUsuario'];
          nomeInfo.innerText = data[key]['nome'];
          nomeUsuarioInfo.innerText = data[key]['nomeUsuario'];
          generoInfo.innerText = data[key]['genero'];
          biInfo.innerText = data[key]['bi'];
          emailInfo.innerText = data[key]['email'];
          enderecoInfo.innerText = data[key]['endereco'];
          telefoneInfo.innerText = data[key]['telefone'];
          dataNascInfo.innerText = data[key]['dataNasc'];
          dataAdesaoInfo.innerText = data[key]['dataAdesao'];
          estadoInfo.innerText = data[key]['estado'];
          tipoUsuarioInfo.innerText = data[key]['tipoUsuario'];

          imgUpdate.style.backgroundImage = "url('images/usuario/" + data[key]['imagem'] + "')";
          imgUpdate.querySelector("i").style.display = "none";

          nome.value = data[key]['nome'];
          nomeUsuario.value = data[key]['nomeUsuario'];

          $('#genero').val(data[key]['genero']);
          $('#genero').select2().trigger('change');

          email.value = data[key]['email'];
          bi.value = data[key]['bi'];

          $('#idTipoUsuario').val(data[key]['idTipoUsuario']);
          $('#idTipoUsuario').select2().trigger('change');
        }
      }
    }).done(function(data) {
      $('#modal-updateUsuario').modal('show');
    });
  }

  function detalhes(id) {
    linhaUsuario = id;
    $.ajax({
      url: "includes/read/queryUser.inc.php",
      type: "post",
      dataType: "json",
      data: {
        idUsuario: id
      },
      success: function(data) {
        for (var key in data) {
          nomeModal.innerText = data[key]["nome"];
          if (data[key]["imagem"] != null) {
            imagemInfo.querySelector('i').style.display = "none";
            imagemInfo.style.backgroundImage = `url('./images/usuario/${data[key]["imagem"]}')`;
          } else {
            imagemInfo.querySelector('i').style.display = "block";
            imagemInfo.style.backgroundImage = ``;
          }
          codigoInfo.innerText = data[key]["idUsuario"];
          nomeInfo.innerText = data[key]["nome"];
          generoInfo.innerText = data[key]["genero"];
          biInfo.innerText = data[key]["bi"];
          emailInfo.innerText = data[key]["email"];
          nomeUsuarioInfo.innerText = data[key]["nomeUsuario"];
          tipoUsuarioInfo.innerText = data[key]["tipoUsuario"];
        }
      }
    });
  }

  $(document).ready(function() {
    $.ajax({
      url: "includes/read/terminal.inc.php",
      type: "post",
      dataType: "json",
      success: function(data) {
        let select = "";
        for (var key in data) {
          select += "<option value=" + data[key]['idTerminal'] + ">" + data[key]['nome'] + "</option>";
        }
        $("#idTerminal").html(select);
      }
    });
  });

  $('#tabelaUsuario').on('click', '.btn-more', function(e) {
    e.preventDefault();
    $('#modal-updateUsuario').modal('show');
    linha = $(this).closest('tr').find('td');
    detalhes($(this).closest('tr').find('td')[0].textContent);
  });

  $('#tabelaUsuario').on('click', '.btn-update', function(e) {
    e.preventDefault();
    let terminal;
    linha = $(this).closest('tr').find('td');
    doOpcao.innerText = "Editar Usuário";
    resetForm();
    $('#modal-documento').modal('show');
    let id = $(this).closest('tr').find('td')[0].textContent;
    $.ajax({
      url: "includes/read/queryUser.inc.php",
      type: "post",
      dataType: "json",
      data: {
        idUsuario: id
      },
      success: function(data) {
        let imagem = document.querySelector('.image-container');
        let iconImage = imagem.querySelector('i');
        for (var key in data) {
          terminal = data[key]['idTerminal'];
          codigo.innerText = data[key]["idUsuario"];
          if (data[key]["imagem"] != null) {
            imagem.style.backgroundImage = `url('./images/usuario/${data[key]["imagem"]}')`;
            iconImage.style.display = "none";
          } else {
            imagem.style.backgroundImage = ``;
            iconImage.style.display = "block";
          }

          if (data[key]["nome"] != "") {
            nome.value = data[key]["nome"];
          } else {
            nome.value = "";
          }

          $('#genero').val(data[key]['genero']);
          $('#genero').select2().trigger('change');

          if (data[key]["bi"] != "") {
            bi.value = data[key]["bi"];
          } else {
            bi.value = "";
          }

          if (data[key]["email"] != "") {
            email.value = data[key]["email"];
          } else {
            email.value = "";
          }

          if (data[key]["nomeUsuario"] != "") {
            nomeUsuario.value = data[key]["nomeUsuario"];
          } else {
            nomeUsuario.value = "";
          }
          var labelEstado = document.querySelector("label[for='estado']");
          if (data[key]["estado"] != null) {
            if (data[key]["estado"] == 0) {
              estado.value = 0;
              estado.checked = false;
              labelEstado.innerText = "Estado - Inactivo";
            } else if (data[key]["estado"] == 1) {
              estado.value = 1;
              estado.checked = true;
              labelEstado.innerText = "Estado - Activo";
            }
          }

          $('#idTipoUsuario').val(data[key]['idTipoUsuario']);
          $('#idTipoUsuario').select2().trigger('change');
        }
      }
    });
    $('#idTerminal').val("");
    $.ajax({
      url: "includes/read/queryTerminalUsuario.inc.php",
      type: "post",
      dataType: "json",
      data: {
        idUsuario: id
      },
      success: function(data) {
        if (data == null) {
          $('#idTerminal').val("");
        }
        $.each(data, function(index, opcao) {
          $('#idTerminal').append(new Option(opcao.nome, opcao.idTerminal, true, true));
        });
        $('#idTerminal').select2();
        if ($("#idTerminal").val().length != 0) {
          let terminal = $("#idTerminal").val();
          let vector = [];
          for (let i = 0; i < $("#idTerminal").val().length; i++) {
            let valor = $("#idTerminal").val()[i];
            let texto = $("#idTerminal option[value='" + $("#idTerminal").val()[i] + "']").text();
            var opcao = {
              valor: valor,
              texto: texto
            }
            vector.push(opcao);
          }
          let valoresTerminal = "";
          for (let j = 0; j < vector.length; j++) {

            valoresTerminal += `<option value="${vector[j]["valor"]}">${vector[j]["texto"]}</option>`;
          }
          $("#terminal").html(valoresTerminal);
          if ($("#idTerminal").val().length > 1) {
            $("#terminal").removeAttr('disabled');
          } else {
            $("#terminal").attr('disabled', 'disabled');
          }
        } else {
          $("#terminal").attr('disabled', 'disabled');
          $("#terminal").html("<option value='0'>Nenhum Terminal Selecionado</option>");
        }
        $('#terminal').val(terminal);
        $('#terminal').select2().trigger('change');
      }
    });
  });

  $('#tabelaUsuario').on('click', '.btn-delete', function(e) {
    e.preventDefault();
    linha = $(this).closest('tr').find('td');
    let id = $(this).closest('tr').find('td')[0].textContent;
    let nome = $(this).closest('tr').find('td')[1].textContent;
    swal.fire({
        title: "Tem a certeza que pretende eliminar Usuário?",
        text: "Usuário: " + nome,
        icon: "warning",
        showCancelButton: true,
        confirmButtonText: 'Confirmar',
        confirmButtonColor: '#560085',
        cancelButtonText: 'Cancelar',
        cancelButtonColor: '#560085',
      })
      .then((result) => {
        if (result.isConfirmed) {
          $.ajax({
            url: "includes/delete/usuario.inc.php",
            type: "post",
            dataType: "json",
            data: {
              idUsuario: id
            },
            success: function(data) {
              swal.fire({
                title: "Usuário " + nome + " eliminado com sucesso!",
                icon: "success",
                confirmButtonText: 'Confirmar',
                confirmButtonColor: '#560085',
              });
              $('#tabelaUsuario').DataTable().row(linha).remove().draw(false);
            },
            error: function(data) {
              swal.fire({
                title: "Erro ao eliminar usuário!",
                text: "Erro ao apagar usuário: " + nome + " !",
                icon: "error",
                confirmButtonText: 'Confirmar',
                confirmButtonColor: '#560085',
              });
            }
          });
        }
      });
  });

  function loadNovoId() {
    $.ajax({
      url: "includes/read/codigoUsuario.inc.php",
      type: "post",
      dataType: "json",
      success: function(data) {
        codigo.innerText = data;
      }
    });
  }

  $('#tabelaArtigo').on('click', '.remove_row', function(e) {
    e.preventDefault();
    var table = $('#tabelaArtigo').DataTable();
    var row = $(this).closest('tr');
    if ($('#tabelaArtigo tbody tr').length > 1) {
      table.row(row).remove().draw();
    } else {
      row.find('.inputSearchArtigo').val("");
      row.find('.descricao').val("");
      row.find('.qtd').val(1);
      row.find('.preco').val("");
      row.find('.desconto').val("0,00%");
      row.find('.imposto').val(0);
      row.find('.imposto').select2().trigger('change');
      row.find('.total').val("");
    }
    totalDocumento();
  });

  $('#tabelaArtigo').on('keypress', '.inputSearchArtigo', function() {
    if (event.which === 13) {
      event.preventDefault();
      funcaoQueryArtigo($(this).val(), $(this));
      totalDocumento();
    }
  });

  $('#tabelaArtigo').on('focusout', '.inputSearchArtigo', function() {
    event.preventDefault();
    if (this.value == "") {
      $(this).closest('tr').find('.inputSearchArtigo').val("");
      $(this).closest('tr').find('.descricao').val("");
      $(this).closest('tr').find('.qtd').val(1);
      $(this).closest('tr').find('.preco').val("");
      $(this).closest('tr').find('.desconto').val("0,00%");
      $(this).closest('tr').find('.imposto').val(0);
      $(this).closest('tr').find('.imposto').select2().trigger('change');
      $(this).closest('tr').find('.total').val("");
    } else {
      funcaoQueryArtigo($(this).val(), $(this));
    }
    totalDocumento();
  });

  $(document).on("click", ".submit", function(e) {
    e.preventDefault();
    if (nome.value != '' && email.value != '' && genero.value != 0 && idTipoUsuario.value != 0 && nomeUsuario.value != '' && bi.value != '') {
      let img = $("#file")[0].files;
      usuario(img);
    }
  });


  function usuario(img) {
    if (doOpcao.innerText == "Novo Usuário") {
      $.ajax({
        url: "includes/create/usuario.inc.php",
        type: "post",
        data: {
          idTipoUsuario: idTipoUsuario.value,
          idTerminal: terminal.value,
          nome: nome.value,
          genero: genero.value,
          bi: bi.value,
          email: email.value,
          nomeUsuario: nomeUsuario.value,
          estado: estado.value,
        },
        success: function(data) {
          for (let i = 0; i < $("#idTerminal").val().length; i++) {
            $.ajax({
              url: "includes/create/terminalUsuario.inc.php",
              type: "post",
              data: {
                idUsuario: data,
                idTerminal: $("#idTerminal").val()[i]
              }
            });
          }
          swal.fire({
            title: "Cadastro efectuado com sucesso!",
            text: "Usuário " + nome.value + " cadastrado!",
            confirmButtonText: 'Confirmar',
            confirmButtonColor: '#560085',
            icon: "success",
          }).then(() => {
            if (img[0] != null) {
              foto(data, img);
            }
          });
          insertLinha(data);
          reload();
        },
        error: function(data) {
          swal.fire({
            title: "Erro ao cadastrar usuário!",
            text: "Erro ao cadastrar usuário: " + nome.value + " !",
            confirmButtonText: 'Confirmar',
            confirmButtonColor: '#560085',
            icon: "error",
          });
        }
      }).done(function(data) {});
    } else {
      $.ajax({
        url: "includes/update/usuario.inc.php",
        type: "post",
        data: {
          idUsuario: codigo.innerText,
          idTipoUsuario: idTipoUsuario.value,
          idTerminal: terminal.value,
          nome: nome.value,
          genero: genero.value,
          bi: bi.value,
          email: email.value,
          nomeUsuario: nomeUsuario.value,
          estado: estado.value,
        },
        success: function(data) {
          swal.fire({
            title: "Informações Actualizadas com sucesso!",
            text: "Usuário " + nome.value + ".",
            confirmButtonText: 'Confirmar',
            confirmButtonColor: '#560085',
            icon: "success",
          }).then(() => {
            if (img[0] != null) {
              foto(codigo.innerText, img);
            }
          });
          updateLinha(linha);
          reload();
        },
        error: function(data) {
          swal.fire({
            title: "Erro ao cadastrar usuário!",
            text: "Erro ao cadastrar usuário: " + nome.value + " !",
            confirmButtonText: 'Confirmar',
            confirmButtonColor: '#560085',
            icon: "error",
          });
        }
      }).done(function(data) {});
    }
  }

  function foto(identificador, img) {
    let form_data = new FormData();
    form_data.append('id', identificador);
    form_data.append('imagem', resizedImage);

    $.ajax({
      url: "includes/create/fotoUsuario.inc.php",
      type: "post",
      data: form_data,
      cache: false,
      contentType: false,
      processData: false,
      success: function(data) {}
    });
  }

  $(document).on("click", "#btn-password", function(e) {
    e.preventDefault();
    swal.fire({
        title: "Tem a certeza que pretende redefinir a senha desse usuário?",
        text: "usuario: ",
        icon: "warning",
        showCancelButton: true,
        confirmButtonText: 'Confirmar',
        confirmButtonColor: '#560085',
        cancelButtonText: 'Cancelar',
        cancelButtonColor: '#560085',
      })
      .then((result) => {
        if (result.isConfirmed) {
          swal.fire({
            title: `<div style="display:flex; justify-content: center;"><div style="height: 7rem; width: 7rem; display: flex; justify-content: center; align-items: center; border: 1px solid #560085; border-radius: 50%; margin: 1rem; text-align: center;"><i class="fa-solid fa-lock" style="color: #560085d6;"></i></div></div><h1>Redefinir senha.</h1>`,
            html: `
              <div style="text-align: left;"><label for="novaSenha" style="padding-left: 10px;">Digite a sua senha</label>
              <div style="display: flex; justify-content: center;"><input type="password" class="form-control" id="novaSenha" style="margin: .4rem 0rem 0rem 0rem; width: calc(100% - 15px); padding: 1.5rem 1rem; font-size: 2rem; padding: 1.5rem 1rem; font-size: 2rem;"></div>
              <small style="margin-bottom: 1rem; visibility: hidden;">Mensagem de Erro</small></div>
              <div style="text-align: left;"><label for="confirmaNovaSenha" style="padding-left: 10px;">Confirme a sua senha</label>
              <div style="display: flex; justify-content: center;"><input type="password" class="form-control" id="confirmaNovaSenha" style="margin: .4rem 0rem 0rem 0rem; width: calc(100% - 15px); padding: 1.5rem 1rem; font-size: 2rem;"></div>
              <small style="margin-bottom: 1rem; visibility: hidden;">Mensagem de Erro</small></div>`,
            confirmButtonText: 'Confirmar',
            confirmButtonColor: "#560085",
            cancelButtonText: 'Cancelar',
            cancelButtonColor: '#560085',
            showCancelButton: true,
            allowOutsideClick: false,
            preConfirm: () => {
              const novaSenha = document.getElementById('novaSenha').value;
              const confirmaNovaSenha = document.getElementById('confirmaNovaSenha').value;
              if (novaSenha == "" || confirmaNovaSenha == "") {
                //document.getElementById('novaSenhaError').style.visibility = 'visible';
                //document.getElementById('confirmaNovaSenhaError').style.visibility = 'visible';
                Swal.showValidationMessage('Defina a sua senha.');
              }
            },
            didOpen: () => {
              let novaSenha = document.querySelector("#novaSenha");
              let confirmaNovaSenha = document.querySelector("#confirmaNovaSenha");
              let smallNovaSenha = novaSenha.parentElement.parentElement.querySelector("small");
              let smallConfirmaNovaSenha = confirmaNovaSenha.parentElement.parentElement.querySelector("small");
              let btn = novaSenha.parentElement.parentElement.parentElement.parentElement.querySelector(".swal2-confirm");
              btn.setAttribute('disabled', 'disabled');

              novaSenha.addEventListener("keyup", function() {
                passwords(novaSenha, confirmaNovaSenha, smallNovaSenha, smallConfirmaNovaSenha, btn);
              });

              confirmaNovaSenha.addEventListener("keyup", function() {
                passwords(novaSenha, confirmaNovaSenha, smallNovaSenha, smallConfirmaNovaSenha, btn);
              });

              function passwords(senha, confirmacao, smallSenha, smallCsenha, btn) {
                if (senha.value != confirmacao.value) {
                  if (senha.value != "" && confirmacao.value != "") {
                    senha.className = "form-control is-invalid";
                    smallSenha.style.visibility = "visible";
                    smallSenha.style.color = "#dc3545";
                    smallSenha.innerText = "Senhas não coinscidem!";
                    confirmacao.className = "form-control is-invalid";
                    smallCsenha.style.visibility = "visible";
                    smallCsenha.style.color = "#dc3545";
                    smallCsenha.innerText = "Senhas não coinscidem!";
                    btn.setAttribute('disabled', 'disabled');
                  } else if (senha.value == '') {
                    senha.className = "form-control";
                    smallSenha.style.visibility = "hidden";
                    smallSenha.style.color = "#dc3545";
                    smallSenha.innerText = "Senhas não coinscidem!";
                    confirmacao.className = "form-control";
                    smallCsenha.style.visibility = "hidden";
                    smallCsenha.style.color = "#dc3545";
                    smallCsenha.innerText = "Senhas não coinscidem!";
                    btn.setAttribute('disabled', 'disabled');
                  } else if (confirmacao.value == '') {
                    senha.className = "form-control";
                    smallCsenha.style.visibility = "hidden";
                    smallCsenha.style.color = "#dc3545";
                    smallCsenha.innerText = "Senhas não coinscidem!";
                    confirmacao.className = "form-control";
                    smallSenha.style.visibility = "hidden";
                    smallSenha.style.color = "#dc3545";
                    smallSenha.innerText = "Senhas não coinscidem!";
                    btn.setAttribute('disabled', 'disabled');
                  }
                } else if (senha.value == '' && confirmacao.value == '') {
                  senha.className = "form-control is-warning";
                  confirmacao.className = "form-control is-warning";
                  smallSenha.style.visibility = "visible";
                  smallSenha.style.color = "#ffc107";
                  smallSenha.innerText = "Campo obrigatório!";
                  smallCsenha.style.visibility = "visible";
                  smallCsenha.style.color = "#ffc107";
                  smallCsenha.innerText = "Campo obrigatório!";
                } else if (senha.value == "") {
                  senha.className = "form-control is-warning";
                  smallSenha.innerText = "Campo obrigatório!";
                  smallSenha.style.color = "#ffc107";
                  smallSenha.style.visibility = "visible";
                  btn.setAttribute('disabled', 'disabled');
                } else if (confirmacao.value == "") {
                  confirmacao.className = "form-control is-warning";
                  smallCsenha.innerText = "Campo obrigatório!";
                  smallCsenha.style.color = "#ffc107";
                  smallCsenha.style.visibility = "visible";
                  btn.setAttribute('disabled', 'disabled');
                } else {
                  senha.className = "form-control is-valid";
                  confirmacao.className = "form-control is-valid";
                  smallSenha.style.visibility = "hidden";
                  smallCsenha.style.visibility = "hidden";
                  btn.removeAttribute('disabled');
                }
              }
            }
          }).then((result) => {
            if (result.isConfirmed) {
              let novaSenha = document.querySelector("#novaSenha");
              let dados = {
                otp: novaSenha.value,
              };
              funcaoUpdate("../pos/includes/updatePassword.inc.php", "post", "json", "usuario", dados, {
                "idUsuario": linhaUsuario
              }, success = (data) => {
                swal.fire({
                  title: "Senha redefinida com sucesso.",
                  text: "Senha do usuário redefinida!",
                  confirmButtonText: 'Confirmar',
                  confirmButtonColor: '#560085',
                  icon: "success",
                });
              }, error = (data) => {
                swal.fire({
                  title: "Erro ao redefinir senha.",
                  text: "Erro ao redefinir a senha do usuário.",
                  confirmButtonText: 'Confirmar',
                  confirmButtonColor: '#560085',
                  icon: "error",
                });
              }, done = (data) => {
                console.log("Terminado: ", data);
              });
            }
          });
        }
      });
  });

  $(document).on("click", "#btn-delete", function(e) {
    e.preventDefault();
    swal.fire({
        title: "Tem a certeza que pretende eliminar usuario?",
        text: "usuario: " + nome.value,
        icon: "warning",
        showCancelButton: true,
        confirmButtonText: 'Confirmar',
        confirmButtonColor: '#560085',
        cancelButtonText: 'Cancelar',
        cancelButtonColor: '#560085',
      })
      .then((result) => {
        if (result.isConfirmed) {
          if (idUsuario != 1) {
            $.ajax({
              url: "php/delete/usuario.php",
              type: "post",
              dataType: "json",
              data: {
                idUsuario: idUsuario
              },
              success: function(data) {
                swal.fire({
                  title: "usuario " + nome.value + " eliminado com sucesso!",
                  icon: "success",
                  confirmButtonText: 'Confirmar',
                  confirmButtonColor: '#560085',
                });
                $('#tabelaUsuario').DataTable().row(linha).remove().draw(false);
              },
              error: function(data) {
                swal.fire({
                  title: "Erro ao eliminar usuario!",
                  text: "Erro ao apagar usuario: " + nome.value + " !",
                  icon: "error",
                  confirmButtonText: 'Confirmar',
                  confirmButtonColor: '#560085',
                });
              }
            });
          } else {
            swal.fire({
              title: "Erro ao eliminar Usuário!",
              text: "Usuário: " + nome.value + " não pode ser eliminado!",
              confirmButtonText: 'Confirmar',
              confirmButtonColor: '#560085',
              icon: "error",
            });
          }
        }
      });
  });
</script>
<script src="./validation/parametroUsuario.js"></script>