<?php include('./header.php'); ?>
<style>
  #result {
    position: absolute;
    width: calc(100% - 45px);
    max-width: 870px;
    cursor: pointer;
    overflow-y: auto;
    max-height: 400px;
    box-sizing: border-box;
    z-index: 1001;
  }

  .link-class:hover {
    background-color: #f1f1f1;
  }

  .markedTest {
    background-color: yellow;
  }
</style>
<link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">

<body class="hold-transition layout-top-nav">
  <div class="wrapper">
    <div class="preloader flex-column justify-content-center align-items-center">
    </div>
    <div class="content-wrapper">
      <div class="content-header">
        <div class="container-fluid">
        </div>
      </div>
      <section class="content">
        <div class="container-fluid">
          <div class="row">
            <div class="col-md-9">
              <div class="col-md-12">
                <div class="card card-default">
                  <div class="card-body button-nav">
                    <div class="row" style="justify-content: end;">
                      <div class="col-md-2">
                        <button class="btn btn-opcao botao-activo" id="btn">Logotipo</button>
                      </div>
                      <div class="col-md-8">
                        <div class="input-group input-group">
                          <input type="text" class="form-control" placeholder="Procurar" title="Procurar Artigo" id="search">
                          <div class="input-group-append">
                            <button type="button" class="btn btn btn-default btnSearch" style="line-height: 0 ;">
                              <i class="fa fa-search"></i>
                            </button>
                          </div>
                        </div>
                        <div class="form-group">
                        <ul class="list-group" id="result"></ul>
                        </div>
                      </div>
                      <div class="col-md-2" style="display: flex; justify-content: end;">
                        <button class="btn btn-opcao botao-activo" id="btnListagemArtigo">Listagem de Artigos</button>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-md-12">
                <div class="row">
                  <div class="col-md-2">
                    <div class="card card-default" style="height: 80vh;">
                      <div class="card-body button-nav">
                        <div class="row">
                          <div class="col-md-12">
                            <div class="row" style="border-bottom: 1px solid #e5e7eb; padding-bottom: .5rem;">
                              <div class="col-md-12">
                                <h3>Categorias</h3>
                              </div>
                            </div>
                          </div>
                          <div class="col-md-12" style="height: 68vh; overflow-y: auto; margin-top: 1rem;" id="cardFamilia">
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-md-10">
                    <div class="card card-default" style="height: 80vh;">
                      <div class="card-body" style="height: 80vh; overflow-y: auto;">
                        <div class="row" id="containerCardProduct">
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-md-3">
              <div class="card card-default" style="height: 90vh;">
                <div class="card-body button-nav">
                  <div class="row">
                    <div class="col-md-12">
                      <div class="row" style="border-bottom: 1px solid #e5e7eb;">
                        <div class="col-md-8">
                          <div class="form-group">
                            <h5>Cliente</h5>
                            <h6 id="textoCliente">Consumidor Final</h6>
                          </div>
                        </div>
                        <div class="col-md-4">
                          <div class="form-group" style="float: right;">
                            <button class="btn btn-opcao botao-activo" id="btn">Adicionar</button>
                          </div>
                        </div>
                        <div class="col-md-12">
                          <div class="form-group" style="margin: 0;">
                            <div class="input-group input-group">
                              <input type="text" class="form-control" placeholder="Procurar" title="Procurar Artigo" id="searchCliente">
                              <div class="input-group-append">
                                <button type="button" class="btn btn btn-default" style="line-height: 0 ;" id="btnSearchCliente">
                                  <i class="fa fa-search"></i>
                                </button>
                              </div>
                            </div>
                            <small>Mensagem de erro</small>
                          </div>
                        </div>
                      </div>
                      <div class="row">
                        <div class="col-md-12">
                          <div style="display: flex; justify-content: space-between;">
                            <div class="col-md-5" style="padding-left: 0;">
                              <div class="form-group p-2" style="font-size: 1rem; margin: 0;">
                                <h5>Descrição</h5>
                              </div>
                            </div>
                            <div class="col-md-3" style="font-size: 1rem; text-align: center;">
                              <div class="form-group p-2" style="margin: 0;">
                                <h5>Qtd.</h5>
                              </div>
                            </div>
                            <div class="col-md-4 p-2" style="font-size: 1rem; text-align: right; padding-right: 0; margin: 0;">
                              <h5>Preço</h5>
                            </div>
                          </div>
                        </div>
                        <div class="col-md-12" id="linhaArtigo" style="height: 50vh; overflow-y: auto;">
                        </div>
                      </div>
                    </div>
                    <div class="col-md-12" style="justify-content: space-between; padding-top: 1rem; position: absolute; bottom: 0; border-top: 1px solid #e5e7eb;">
                      <div class="row">
                        <div class="col-md-12" style="display: flex; justify-content: space-between;">
                          <div class="form-group">
                            <h1 style="font-size: 1.5rem; font-weight: 500;">TOTAL</h1>
                          </div>
                          <div class="form-group">
                            <h1 style="font-size: 1.5rem; font-weight: 500;" id="totalAbsoluto">0,00</h1>
                          </div>
                        </div>
                      </div>
                      <div class="row" style="border-top: 1px solid #e5e7eb; padding-top: 1rem;">
                        <div class="col-md-2">
                          <div class="form-group">
                            <button class="btn btn-opcao botao-activo" id="btnLimpar" style="background-color: #dc3545; border-color: #dc3545"><i class="fas fa-trash"></i></button>
                          </div>
                        </div>
                        <div class="col-md-2">
                          <div class="form-group">
                            <button class="btn btn-opcao botao-activo" id="btn" style="background-color: #28a745; border-color: #28a745;"><i class="fas fa-save"></i></button>
                          </div>
                        </div>
                        <div class="col-md-8">
                          <div class="form-group">
                            <button class="btn btn-opcao botao-activo btn-layout" id="./formLayoutTicket.php" style="width: 100%;">Fechar Conta</button>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
      <div class="modal fade" id="modal-formCliente">
        <div class="modal-dialog modal-xl">
          <div class="modal-content">
            <div class="modal-header">
              <div class="container">
                <div class="progress-barra">
                  <div class="step">
                    <p style="margin: 0;">Formulário de Entidade</p>
                  </div>
                </div>
              </div>
            </div>
            <div class="modal-body">
              <div class="container">
                <div class="card-body form-outer" style="padding: 0;">
                  <div class="formulario">
                    <div class="page slidePage">
                      <div class="row">
                        <div class="col-md-12">
                          <h5 style="margin-bottom: 1rem; justify-content: center;"><span id="doOpcao"></span> - <span id="codigo"></span></h5>
                          <div class="row">
                            <div class="col-md-2" style="text-align: -webkit-center;">
                              <div class="form-group margem">
                                <div class="wrapper-image">
                                  <div class="image-container">
                                    <i class="fas fa-image"></i>
                                  </div>
                                  <label for="file" class="camera-icon">
                                    <i class="fas fa-camera"></i>
                                  </label>
                                  <input type="file" id="file" name="file" accept="image/*" hidden>
                                </div>
                              </div>
                            </div>
                            <div class="col-md-2"></div>
                            <div class="col-md-4">
                              <div class="form-group" style="margin-top: .4rem;">
                                <small>Mensagem de erro</small>
                                <div class="custom-control custom-switch">
                                  <input type="checkbox" class="custom-control-input" name="estado" id="estado" value="1" checked>
                                  <label class="custom-control-label" for="estado">Estado - Activo</label>
                                </div>
                              </div>
                            </div>
                            <div class="col-md-4">
                              <div class="form-group" style="margin-top: .4rem;">
                                <small>Mensagem de erro</small>
                                <div class="custom-control custom-switch">
                                  <input type="checkbox" class="custom-control-input" name="retencaoFonte" id="retencaoFonte" value="0">
                                  <label class="custom-control-label" for="retencaoFonte">Retenção na Fonte - Inactiva</label>
                                </div>
                              </div>
                            </div>
                            <div class="col-md-4">
                              <div class="form-group" style="margin-bottom: 0;">
                                <small class="required">Nome</small>
                                <input type="text" class="form-control" id="nome" name="nome" placeholder="Nome Entidade" title="Nome Entidade" data-campo="Nome" required>
                                <small>Mensagem de erro</small>
                              </div>
                              <div class="form-group" style="margin-bottom: 0;">
                                <small class="required">Nome Comercial</small>
                                <input type="text" class="form-control" id="nomeComercial" name="nomeComercial" placeholder="Nome Comercial" title="Nome Comercial" data-campo="Nome Comercial" required>
                                <small>Mensagem de erro</small>
                              </div>
                              <div class="form-group" style="margin-bottom: 0;">
                                <small class="required">Tipo de Entidade</small>
                                <select class="form-control select2" style="width: 100%;" id="idTipoEntidade" name="idTipoEntidade" data-campo="Tipo de Entidade">
                                  <option value="0">Selecione Tipo de Entidade</option>
                                </select>
                                <small>Mensagem de erro</small>
                              </div>
                            </div>
                            <div class="col-md-4">
                              <div class="form-group" style="margin-bottom: 0;">
                                <small class="required">NIF (Número de Identificação Fiscal)</small>
                                <input type="text" class="form-control" id="nif" name="nif" placeholder="NIF (Número de Identificação Fiscal)" title="NIF (Número de Identificação Fiscal)" data-campo="NIF" required>
                                <small>Mensagem de erro</small>
                              </div>
                              <div class="form-group" style="margin-bottom: 0;">
                                <small class="not-required">Bilhete de Identidade</small>
                                <input type="text" class="form-control" id="bi" name="bi" placeholder="Bilhete de Identidade" title="Nº Bilhete de Identidade" data-campo="BIlhete de Identidade" required>
                                <small>Mensagem de erro</small>
                              </div>
                              <div class="form-group" style="margin-bottom: 0;">
                                <small class="required">Linha de Preço Pré-definida</small>
                                <select class="form-control select2 not-required" style="width: 100%;" id="linhaPrecoPredefinida" name="linhaPrecoPredefinida" data-campo="Linha de Preço Pré-definida">
                                  <option value="0">Selecione Linha de Preço</option>
                                </select>
                                <small>Mensagem de erro</small>
                              </div>
                            </div>
                            <div class="col-md-4">
                              <div class="form-group" style="margin-bottom: 0;">
                                <small class="not-required">Localidade</small>
                                <input type="text" class="form-control" id="localidade" name="localidade" placeholder="Localidade" title="Localidade" data-campo="Localidade" required>
                                <small>Mensagem de erro</small>
                              </div>
                              <div class="form-group" style="margin-bottom: 0;">
                                <small class="not-required">Data de Nascimento</small>
                                <input type="date" class="form-control" id="dataNasc" name="dataNasc" placeholder="Data de Nascimento" title="Data de Nascimento" data-campo="Data de Nascimento" required>
                                <small>Mensagem de erro</small>
                              </div>
                              <div class="form-group" style="margin-bottom: 0;">
                                <small class="not-required">Morada</small>
                                <textarea rows="1" type="text" class="form-control" id="morada" name="morada" placeholder="Morada" title="Morada" data-campo="Morada" required></textarea>
                                <small>Mensagem de erro</small>
                              </div>
                            </div>
                          </div>
                        </div>
                        <div class="col-md-12" style=" bottom: 0; padding-top: 14px;">
                          <div class="form-group margem">
                            <small>Mensagem de erro</small>
                            <div class="form-group field btns">
                              <button class="btn btn-block btn-primary submit next" style="margin-top: 0;" id="btnCreateEntidade">
                                Gravar Entidade
                              </button>
                            </div>
                          </div>
                        </div>
                      </div>

                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
      </div>
      <div class="modal fade" id="modal-cliente">
        <div class="modal-dialog modal-xl">
          <div class="modal-content">
            <div class="modal-header">
              <h4 class="modal-title">Clientes</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <table id="tabelaCliente" class="table table-hover table-bordered table-striped">
                <thead>
                  <tr style="text-align: center;">
                    <th title="Identificador da Entidade">Ref. Entidade</th>
                    <th title="Nome">Nome</th>
                    <th title="Nome Comercial">Nome Comercial</th>
                    <th title="Bilhete de Identidade do Cliente">B.I</th>
                    <th title="NIF do Cliente">NIF</th>
                    <th title="Localidade do Cliente">Localidade</th>
                    <th title="Morada do Cliente">Morada</th>
                  </tr>
                </thead>
                <tbody style="text-align: center;">
                </tbody>
              </table>
            </div>
            <div class="modal-footer justify-content-between">
              <button type="button" class="btn btn-default" data-dismiss="modal">Cancelar</button>
              <button type="button" class="btn btn-primary" id="btnSelectCliente" disabled>Confirmar</button>
            </div>
          </div>
        </div>
      </div>
      <div class="modal fade" id="modal-artigo">
        <div class="modal-dialog modal-xl">
          <div class="modal-content">
            <div class="modal-header">
              <h4 class="modal-title">Artigos</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <table id="tabelaArtigoListagem" class="table table-hover table-bordered table-striped">
                <thead>
                  <tr style="text-align: center;">
                    <th title="Referência">Referência</th>
                    <th title="Descrição do Artigo">Descrição</th>
                    <th title="Preço do Artigo (C/Imp)">Preço (C/Imp)</th>
                    <th title="Qtd. Stock">Qtd. Stock</th>
                  </tr>
                </thead>
                <tbody style="text-align: center;">
                </tbody>
              </table>
            </div>
            <div class="modal-footer justify-content-between">
              <button type="button" class="btn btn-default" data-dismiss="modal">Cancelar</button>
              <button type="button" class="btn btn-primary" id="btnSelectArtigo" disabled>Confirmar</button>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="modal fade" id="modal-updateTipoEntidade">
      <div class="modal-dialog modal-xl">
        <div class="modal-content">
          <div class="modal-header" style="padding: 0.5rem;">
            <h3 class="card-title p-3">Cliente: <span id="nomeModal"></span></h3>
          </div>
          <div class="modal-body" style="padding-bottom: 0px;">
            <div class="row">
              <div class="col-md-12">
                <form name="tabelaInfo">
                  <table name="tabelaInfo" class="table table-sm table-bordered" style="min-width: 100%;
                      max-width: 100%;">
                    <tr name="linhaItem">
                      <td style="padding: 20px 0px 0px 10px;">
                        <p>Ref. da Cliente: <span id="codigoInfo"></span></p>
                        <p>Descrição: <span id="nomeInfo"></span></p>
                        <p>Observações: <span id="notaInfo"></span></p>
                      </td>
                    </tr>
                  </table>
                </form>
              </div>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Fechar</button>
          </div>
        </div>
      </div>
    </div>
    <div class="modal fade" id="modal-layout">
      <div class="modal-dialog modal-lg">
        <div class="modal-content">
          <div class="modal-header">
            <h4 class="modal-title">Documento</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="row">
              <div class="col-md-12">
                <iframe id="layoutDocumento" frameborder="0" width="100%" style="height: 60vh;"></iframe>
              </div>
            </div>
          </div>
          <div class="modal-footer justify-content-between">
            <button type="button" class="btn btn-default" data-dismiss="modal">Fechar</button>
            <button type="button" class="btn btn-primary" id="btn-print">Imprimir</button>
          </div>
        </div>
        <!-- /.modal-content -->
      </div>
      <!-- /.modal-dialog -->
    </div>
    <?php include('footer.php'); ?>
</body>

</html>
<script>
  let linha;
  let clienteSelecionado;
  let valores = [];
  let valoresDuplicados = [];

  $(document).ready(function() {
    $('#search').keyup(function() {
      $('#result').html('');
      var searchField = $('#search').val();
      var expression = new RegExp(searchField, "i");
      funcaoSelect("includes/select.inc.php", "post", "json", "artigo", function success(data) {
        console.log("DADOS: ", data);
        if (data != null) {
          for (let i = 0; i < data.length; i++) {
            if (expression.test(data[i]["nome"])) {
              var nomeDestacado = data[i]["nome"].replace(expression, function(match) {
                return '<span class="markedTest">' + match + '</span>';
              });
              $('#result').append('<li class="list-group-item">' + nomeDestacado + '</li>');
            }
          }
        }
      }, function error(data) {

      }, function done(data) {

      });
    });
  });

  $('#search').keyup(function() {

  });


  $(document).on('click', '.btn-layout', function(e) {
    e.preventDefault();
    var iframe = document.getElementById('layoutDocumento');

    function loadDocumento() {
      let tela = iframe.contentWindow.document.body;

      const dataAtual = new Date();
      const dia = String(dataAtual.getDate()).padStart(2, '0');
      const mes = String(dataAtual.getMonth() + 1).padStart(2, '0');
      const ano = dataAtual.getFullYear();
      const hora = String(dataAtual.getHours()).padStart(2, '0');
      const minuto = String(dataAtual.getMinutes()).padStart(2, '0');
      const segundo = String(dataAtual.getSeconds()).padStart(2, '0');
      console.log(`Hora atual: ${hora}:${minuto}:${segundo}`);


      if (searchCliente.value == "") {
        searchCliente.value = "999999999";
      }

      let select = "";
      let linha = linhaArtigo.querySelectorAll('.linha');
      for (let i = 0; i < linha.length; i++) {
        select += `
      <tr>
        <td style="text-align: left;">${linha[i].querySelector('.quantity').value.replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</td>
        <td style="text-align: left;">${linha[i].querySelector('.descricao').innerText}</td>
        <td style="text-align: right;">${parseFloat(linha[i].querySelector('.total').innerText.replace(/\ /g, '').replace(/\,/g, '.')).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</td>
        <td style="text-align: right;">${parseFloat(parseFloat(linha[i].querySelector('.total').innerText.replace(/\ /g, '').replace(/\,/g, '.')) * parseFloat(linha[i].querySelector('.quantity').value.replace(/\ /g, '').replace(/\,/g, '.'))).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</td>
      </tr>
      `;
      }
      console.log("VAMOS PEGAR: ", tela.querySelector('#tabelaDocumento'));
      tela.querySelector('#tabelaDocumento').innerHTML = select;
      tela.querySelector('#dataEmissaoDocumento').innerText = `${dia}-${mes}-${ano} ${hora}:${minuto}:${segundo}`;
      tela.querySelector('#viaDocumento').innerText = "ORIGINAL";
      tela.querySelector('#clienteDocumento').innerText = $('#textoCliente').text();
      tela.querySelector('#nifDocumento').innerText = searchCliente.value;
      console.log("Ver tudo: ", tela.querySelector('#clienteDocumento'));
    }
    iframe.onload = loadDocumento;
    iframe.src = this.id;
    $('#modal-layout').modal('show');
  });

  $(document).on("click", "#btn-print", function(e) {
    var iframe = document.getElementById('layoutDocumento');
    iframe.contentWindow.print();
  });

  $(document).on("click", "#btnListagemArtigo", function(e) {
    e.preventDefault();
    $('#modal-artigo').modal('show');
  });

  $(document).on("click", "#btnLimpar", function(e) {
    e.preventDefault();
    linhaArtigo.innerHTML = "";
    totalAbsoluto.innerText = "0,00";
    funcaoSearchCliente(1);
    valores.length = 0;
    valoresDuplicados.length = 0;
  });

  $(document).on("click", "#btnCreateEntidade", function(e) {
    e.preventDefault();
    let required = document.querySelector("#modal-formCliente").querySelectorAll('.required');
    let todosPreenchidos = true;

    for (let i = 0; i < required.length; i++) {
      if (required[i].parentElement.querySelector('input') != null) {
        if (required[i].parentElement.querySelector('input').value === "") {
          todosPreenchidos = false;
          break;
        }
      }
    }

    if (todosPreenchidos) {
      let img = $("#file")[0].files;
      entidade(img);
    }
  });

  function entidade(img) {
    let dados = {
      idUsuario: 1,
      nome: nome.value,
      nomeComercial: nomeComercial.value,
      nif: nif.value,
      bi: bi.value,
      localidade: localidade.value,
      dataNasc: dataNasc.value,
      morada: morada.value,
      idTipoEntidade: 2,
      linhaPreco: linhaPrecoPredefinida.value,
      retencaoFonte: retencaoFonte.value,
      estado: estado.value,
    };
    let tabela = "entidade";

    funcaoInsert("includes/insert.inc.php", "post", "json", tabela, dados, function success(data) {
      swal.fire({
        title: "Cadastro efectuado com sucesso!",
        text: "Cliente " + nome.value + " cadastrado!",
        confirmButtonText: 'Confirmar',
        confirmButtonColor: '#560085',
        icon: "success",
      });
      $('#modal-formCliente').modal('hide');
    }, function error(data) {
      swal.fire({
        title: "Erro ao cadastrar Cliente!",
        text: "Erro ao cadastrar Cliente: " + nome.value + " !",
        confirmButtonText: 'Confirmar',
        confirmButtonColor: '#560085',
        icon: "error",
      });
    }, function done(data) {

    });
  }

  $(document).on("change", "#estado", function(e) {
    e.preventDefault();
    var labelEstado = document.querySelector("label[for='estado']");
    if (estado.checked == true) {
      estado.value = 1;
      labelEstado.innerText = "Estado - Activo";
    } else {
      estado.value = 0;
      labelEstado.innerText = "Estado - Inactivo";
    }
  });

  $(document).on("change", "#retencaoFonte", function(e) {
    e.preventDefault();
    var labelRetencaoFonte = document.querySelector("label[for='retencaoFonte']");
    if (retencaoFonte.checked == true) {
      retencaoFonte.value = 1;
      labelRetencaoFonte.innerText = "Retenção na Fonte - Activa";
    } else {
      retencaoFonte.value = 0;
      labelRetencaoFonte.innerText = "Retenção na Fonte - Inactiva";
    }
  });

  $(document).on("keypress", "#searchCliente", function(e) {
    if (e.which === 13) {
      e.preventDefault();
      funcaoSearchCliente(this.value);
    }
  });

  function funcaoSearchArtigo(parametro) {
    let resultado = mesmoArtigoVerify(parametro.find('td')[0].textContent);
    if (resultado.length > 0) {
      var elementos = valoresDuplicados.filter(function(valor) {
        return valor === parametro.find('td')[0].textContent;
      });
      if (elementos.length > 0) {
        let linha = linhaArtigo.querySelectorAll('.linha');
        for (let i = 0; i < linha.length; i++) {
          if (parametro.find('td')[0].textContent === linha[i].getAttribute('data-linha')) {
            let valor = linha[i].querySelector('.quantity');
            if (valor.value == "") {
              valor.value = 1;
            } else {
              valor.value = parseInt(valor.value) + 1;
              totalDocumento();
            }
            linha[i].querySelector('.total').innerText = parseFloat(linha[i].querySelector('.quantity').value.replace(/\ /g, '').replace(/\,/g, '.')) * parseFloat(parametro.find('td')[2].textContent.replace(/\ /g, '').replace(/\,/g, '.'));
            linha[i].querySelector('.total').innerText = parseFloat(linha[i].querySelector('.total').innerText).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ");
          }
        }
        totalDocumento();
      } else {
        let select = `
      <div class="row linha" data-linha="${parametro.find('td')[0].textContent}" style="border-bottom: 1px solid #e5e7eb; padding: 0;">
        <div class="col-md-12">
          <div style="display: flex; justify-content: space-between;">
            <div class="col-md-5" style="padding-left: 0;">
              <div class="form-group p-2" style="font-size: 1rem; margin: 0;">
                <h6 class="text-sm descricao" id="textoCliente">${parametro.find('td')[1].textContent}</h6>
              </div>
            </div>
            <div class="col-md-3" style="font-size: 1rem; text-align: center; display: flex;">
              <div class="form-group p-2" style="margin: 0;">
                <div class="flex items-center text-sm">
                  <button class="text-gray-700 font-semibold rounded-full decrement">-</button>
                  <input type="text" class="border-gray-200 rounded-none w-8 text-center quantity" value="1">
                  <button class="text-gray-700 font-semibold rounded-full increment">+</button>
                </div>
              </div>
            </div>
            <div class="col-md-4 p-2" style="margin: 0; font-size: 1rem; text-align: right;">
              <div class=" text-sm">
              <p class="border-gray-200 rounded-none text-center  float-right total">${parseFloat(parametro.find('td')[2].textContent.replace(/\ /g, '').replace(/\,/g, '.')).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</P>
            </div>
          </div>
        </div>
      </div>
      `;
        $('#linhaArtigo').append(select);
      }
      totalDocumento();
    } else {
      let select = `
      <div class="row linha" data-linha="${parametro.find('td')[0].textContent}" style="border-bottom: 1px solid #e5e7eb; padding: 0;">
        <div class="col-md-12">
          <div style="display: flex; justify-content: space-between;">
            <div class="col-md-5" style="padding-left: 0;">
              <div class="form-group p-2" style="font-size: 1rem; margin: 0;">
                <h6 class="text-sm descricao" id="textoCliente">${parametro.find('td')[1].textContent}</h6>
              </div>
            </div>
            <div class="col-md-3" style="font-size: 1rem; text-align: center; display: flex;">
              <div class="form-group p-2" style="margin: 0;">
                <div class="flex items-center text-sm">
                  <button class="text-gray-700 font-semibold rounded-full decrement">-</button>
                  <input type="text" class="border-gray-200 rounded-none w-8 text-center quantity" value="1">
                  <button class="text-gray-700 font-semibold rounded-full increment">+</button>
                </div>
              </div>
            </div>
            <div class="col-md-4 p-2" style="margin: 0; font-size: 1rem; text-align: right;">
              <div class=" text-sm">
              <p class="border-gray-200 rounded-none text-center  float-right total">${parseFloat(parametro.find('td')[2].textContent.replace(/\ /g, '').replace(/\,/g, '.')).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</P>
            </div>
          </div>
        </div>
      </div>
      `;
      $('#linhaArtigo').append(select);
    }
  }

  function funcaoSearchCliente(parametro) {
    funcaoQuerySelect("includes/querySelect.inc.php", "post", "json", {
      codigoEntidade: parametro,
      idTipoEntidade: 2
    }, "viewEntidade", function success(data) {
      console.log("Dados: ", data);
      let small = $('#searchCliente').closest('.col-md-12').find('small');
      if (data != null) {
        document.querySelector('#textoCliente').innerText = data[0]["nome"];
        small.css('visibility', 'hidden');
        searchCliente.value = data[0]["codigoEntidade"];
      } else {
        document.querySelector('#textoCliente').innerText = "Consumidor Final";
        small.css('visibility', 'visible');
        small.text('Cliente Inexistente');
        small.css('color', '#dc3545');
      }
    }, function error(data) {

    }, function done(data) {

    });
  }

  funcaoSelect("includes/select.inc.php", "post", "json", "familia", function success(data) {
    console.log(data);
    let select = "";
    for (let i = 0; i < data.length; i++) {
      select += `
      <div class="form-group linhaFamilia" data-familia="${data[i]["idFamilia"]}">
        <button class="btn btn-opcao botao-activo" style="width: 100%;">${data[i]["nome"]}</button>
      </div>
      `;
    }
    $('#cardFamilia').html(select);
  }, function error(data) {

  }, function done(data) {
    loadClickedFamilia();
  });

  async function loadCardArtigo(data) {
    let select = "";
    for (let i = 0; i < data.length; i++) {
      select += `
      <div class="col-md-3">
        <div class="card card-default">
          <div class="card-body button-nav cardArtigo" data-artigo="${data[i]["idArtigo"]}">
            <div class="row">
              <div class="col-md-12">
                <div class="form-group" style="margin: 0;">
                  <div class="row">
                    <div class="col-md-4">
                      <div class="row">
                        <div class="col-md-12">
                          <div class="form-group" style="margin-bottom: .2rem;">
                            <div style="width: 4rem; height: 4rem; border: 1px solid #e5e7eb; border-radius: .5rem; background-image: url(./images/artigo/${data[i]["imagem"] != null ? data[i]["imagem"] : "product.svg"}); background-size: contain;"></div>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-md-8" style="padding: 0;">
                      <div style="display: flex; justify-content: space-between;">
                        <small class="not-required">Preço</small><small class="not-required" style="color: ${data[i]["stock"] <= 0 ? "#dc3545" : "#28a745"};padding-right: .5rem;">${data[i]["stock"] <= 0 ? "Indisponível" : "Disponível"}</small>
                      </div>
                      <p style="font-size: 1rem; margin-bottom: 0;">${data[i]["precoComImposto"]}</p>
                      <small class="not-required">Stock: <span>${data[i]["stock"]}</span></small>
                    </div>
                  </div>
                </div>
                <p style="margin-bottom: 0;">${data[i]["nome"]}</p>
              </div>
            </div>
          </div>
        </div>
      </div>
        `;
    }
    $('#containerCardProduct').html(select);
  }

  async function getDefinicao() {
    try {
      let resultado = await new Promise(function(sucesso, erro) {
        funcaoSelect("includes/select.inc.php", "post", "json", "definicao", function success(data) {
          sucesso(data);
        }, function error(data) {
          erro(data);
        }, function done(data) {

        });
      });
      return resultado;
    } catch (erro) {
      throw erro;
    }
  }
  async function getQueryArtigoFamilia(familia) {
    try {
      let resultado = await new Promise(function(sucesso, erro) {
        funcaoQuerySelect("includes/querySelect.inc.php", "post", "json", {
          idFamilia: familia
        }, "viewartigousuariofamilia", function success(data) {
          sucesso(data);
        }, function error(data) {
          erro(data);
        }, function done(data) {

        });
      });
      return resultado;
    } catch (erro) {
      throw erro;
    }
  }

  async function getQueryArtigo(artigo) {
    try {
      let resultado = await new Promise(function(sucesso, erro) {
        funcaoQuerySelect("includes/querySelect.inc.php", "post", "json", {
          idArtigo: artigo
        }, "viewartigousuariofamilia", function success(data) {
          sucesso(data);
        }, function error(data) {
          erro(data);
        }, function done(data) {

        });
      });
      return resultado;
    } catch (erro) {
      throw erro;
    }
  }

  async function getArtigo() {
    try {
      let resultado = await new Promise(function(sucesso, erro) {
        funcaoSelect("includes/select.inc.php", "post", "json", "viewartigousuariofamilia", function success(data) {
          sucesso(data);
        }, function error(data) {
          erro(data);
        }, function done(data) {

        });
      });
      return resultado;
    } catch (erro) {
      throw erro;
    }
  }

  async function getPreco(artigo, linhaPreco) {
    try {
      let resultado = await new Promise(function(sucesso, erro) {
        funcaoQuerySelect("includes/querySelect.inc.php", "post", "json", {
          idArtigo: artigo,
          indice: linhaPreco
        }, "precoArtigo", function success(data) {
          sucesso(data);
        }, function error(data) {
          erro(data);
        }, function done(data) {

        });
      });
      return resultado;
    } catch (erro) {
      throw erro;
    }
  }

  async function getStock(artigo) {
    try {
      let resultado = await new Promise(function(sucesso, erro) {
        funcaoQuerySelect("includes/querySelect.inc.php", "post", "json", {
          idArtigo: artigo
        }, "artigoStock", function success(data) {
          sucesso(data);
        }, function error(data) {
          erro(data);
        }, function done(data) {

        });
      });
      return resultado;
    } catch (erro) {
      throw erro;
    }
  }

  function totalDocumento() {
    let all = 0;
    let total = document.querySelectorAll(".total");
    for (let i = 0; i < total.length; i++) {
      if (total[i].innerText != "") {
        all += parseFloat(total[i].innerText.replace(/\ /g, '').replace(/\,/g, '.'));
        console.log("VER TOTAL: ", all);
      }
    }
    totalAbsoluto.innerText = all;
    totalAbsoluto.innerText = parseFloat(all).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ");
  }

  function loadClickedFamilia() {
    $('.linhaFamilia').on('click', function(e) {
      e.preventDefault();
      getDefinicao()
        .then(dataDefinicao => {
          getQueryArtigoFamilia($(this).attr('data-familia')).then(dataArtigo => {
            if (dataArtigo != null) {
              let promises = [];
              for (let i = 0; i < dataArtigo.length; i++) {
                let precoPromise = getPreco(dataArtigo[i]["idArtigo"], dataDefinicao[1]["valor"]);
                let stockPromise = getStock(dataArtigo[i]["idArtigo"]);

                promises.push(precoPromise);
                promises.push(stockPromise);
              }

              Promise.all(promises).then(results => {

                for (let i = 0; i < dataArtigo.length; i++) {
                  let precoIndex = i * 2;
                  let stockIndex = i * 2 + 1;

                  dataArtigo[i].precoSemImposto = parseFloat(results[precoIndex][0]['semImposto']).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ");
                  dataArtigo[i].precoComImposto = parseFloat(results[precoIndex][0]['semImposto']).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ");
                  dataArtigo[i].stock = parseFloat(results[stockIndex][0]["qtdDisponivel"]).toFixed(0).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ");
                }
                loadCardArtigo(dataArtigo).then(function(data) {
                  loadClickedArtigo();
                });
              }).catch(erro => {
                console.error('Erro: ', erro);
              });
            }
          }).catch(erro => {
            console.error('Erro:', erro);
          });
        })
        .catch(erro => {
          console.error('Erro:', erro);
        });
    });
  }

  function loadClickedArtigo() {
    $('.cardArtigo').on('click', function(e) {
      e.preventDefault();
      getDefinicao()
        .then(dataDefinicao => {
          getQueryArtigo($(this).attr('data-artigo')).then(dataArtigo => {
            getPreco(dataArtigo[0]["idArtigo"], dataDefinicao[1]["valor"]).then(dataPreco => {
              let resultado = mesmoArtigoVerify($(this).attr('data-artigo'));
              if (resultado.length > 0) {
                var elementos = valoresDuplicados.filter(function(valor) {
                  return valor === dataArtigo[0]["idArtigo"];
                });
                if (elementos.length > 0) {
                  let linha = linhaArtigo.querySelectorAll('.linha');
                  for (let i = 0; i < linha.length; i++) {
                    if (dataArtigo[0]["idArtigo"] === linha[i].getAttribute('data-linha')) {
                      let valor = linha[i].querySelector('.quantity');
                      if (valor.value == "") {
                        valor.value = 1;
                      } else {
                        valor.value = parseInt(valor.value) + 1;
                        totalDocumento();
                      }
                      linha[i].querySelector('.total').innerText = parseFloat(linha[i].querySelector('.quantity').value.replace(/\ /g, '').replace(/\,/g, '.')) * parseFloat(dataPreco[0]["comImposto"].replace(/\ /g, '').replace(/\,/g, '.'));
                      linha[i].querySelector('.total').innerText = parseFloat(linha[i].querySelector('.total').innerText).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ");
                    }
                  }
                  totalDocumento();
                } else {
                  calcLinhas(dataArtigo, dataPreco)
                }
                totalDocumento();
              } else {
                calcLinhas(dataArtigo, dataPreco);
              }
            });
          }).catch(erro => {
            console.error('Erro: ', erro);
          });

        }).catch(erro => {
          console.error('Erro: ', erro);
        });
    });
  }

  function calcLinhas(dataArtigo, dataPreco) {
    let select = `
                <div class="row linha" data-linha="${dataArtigo[0]["idArtigo"]}" style="border-bottom: 1px solid #e5e7eb; padding: 0;">
                  <div class="col-md-12">
                    <div style="display: flex; justify-content: space-between;">
                      <div class="col-md-5" style="padding-left: 0;">
                        <div class="form-group p-2" style="font-size: 1rem; margin: 0;">
                          <h6 class="text-sm descricao" id="textoCliente">${dataArtigo[0]["nome"]}</h6>
                        </div>
                      </div>
                      <div class="col-md-3" style="font-size: 1rem; text-align: center; display: flex;">
                        <div class="form-group p-2" style="margin: 0;">
                          <div class="flex items-center text-sm">
                            <button class="text-gray-700 font-semibold rounded-full decrement">-</button>
                            <input type="text" class="border-gray-200 rounded-none w-8 text-center quantity" value="1">
                            <button class="text-gray-700 font-semibold rounded-full increment">+</button>
                          </div>
                        </div>
                      </div>
                      <div class="col-md-4 p-2" style="margin: 0; font-size: 1rem; text-align: right;">
                        <div class=" text-sm">
                        <p class="border-gray-200 rounded-none text-center  float-right total">${parseFloat(dataPreco[0]["comImposto"]).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</P>
                      </div>
                    </div>
                  </div>
                </div>
                `;
    $('#linhaArtigo').append(select);
    let decremento = document.querySelectorAll('.decrement');
    let incremento = document.querySelectorAll('.increment');
    let qtd = document.querySelectorAll('.quantity');
    let total = document.querySelectorAll('.total');

    decremento[decremento.length - 1].addEventListener("click", function(e) {
      if (qtd[decremento.length - 1].value > 1) {
        qtd[decremento.length - 1].value = parseInt(qtd[decremento.length - 1].value) - 1;
        total[decremento.length - 1].innerText = parseFloat(qtd[decremento.length - 1].value.replace(/\ /g, '').replace(/\,/g, '.')) * parseFloat(dataPreco[0]["comImposto"].replace(/\ /g, '').replace(/\,/g, '.'));
        total[decremento.length - 1].innerText = parseFloat(total[decremento.length - 1].innerText).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ");
        totalDocumento();
      }
    });
    incremento[incremento.length - 1].addEventListener("click", function(e) {
      qtd[incremento.length - 1].value = parseInt(qtd[incremento.length - 1].value) + 1;
      total[incremento.length - 1].innerText = parseFloat(qtd[incremento.length - 1].value.replace(/\ /g, '').replace(/\,/g, '.')) * parseFloat(dataPreco[0]["comImposto"].replace(/\ /g, '').replace(/\,/g, '.'));
      total[decremento.length - 1].innerText = parseFloat(total[decremento.length - 1].innerText).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ");
      totalDocumento();
    });
    totalDocumento();
  }

  getDefinicao()
    .then(dataDefinicao => {
      getArtigo().then(dataArtigo => {
        let promises = [];
        for (let i = 0; i < dataArtigo.length; i++) {
          let precoPromise = getPreco(dataArtigo[i]["idArtigo"], dataDefinicao[1]["valor"]);
          let stockPromise = getStock(dataArtigo[i]["idArtigo"]);

          promises.push(precoPromise);
          promises.push(stockPromise);
        }

        Promise.all(promises).then(results => {

          for (let i = 0; i < dataArtigo.length; i++) {
            let precoIndex = i * 2;
            let stockIndex = i * 2 + 1;

            dataArtigo[i].precoSemImposto = parseFloat(results[precoIndex][0]['semImposto']).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ");
            dataArtigo[i].precoComImposto = parseFloat(results[precoIndex][0]['semImposto']).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ");
            dataArtigo[i].stock = parseFloat(results[stockIndex][0]["qtdDisponivel"]).toFixed(0).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ");
          }

          loadCardArtigo(dataArtigo).then(function(data) {
            loadClickedArtigo();
          });
          loadListagemArtigo(dataArtigo);
        });
      }).catch(erro => {
        console.error('Erro:', erro);
      });
    })
    .catch(erro => {
      console.error('Erro:', erro);
    });


  function loadListagemArtigo(data) {
    $("#tabelaArtigoListagem").DataTable({
      select: 'single',
      "aaData": data,
      "columns": [{
        data: "idArtigo"
      }, {
        data: "nome"
      }, {
        data: "precoComImposto"
      }, {
        data: "stock"
      }],
      columnDefs: [{
        targets: -1,
        orderable: false
      }],
      "responsive": true,
      "lengthChange": false,
      "autoWidth": false,
      "language": idiomaPortugues,
      lengthMenu: [
        [7, 25, 50, -1],
        [10, 25, 50, 'All']
      ],
    }).buttons().container().appendTo('#tabelaArtigoListagem_wrapper .col-md-6:eq(0)');
  }
  /*
  for (let i = 0; i < data.length; i++) {
        funcaoQuerySelect("includes/querySelect.inc.php", "post", "json", {
          idArtigo: data[i]["idArtigo"],
          indice: linhaPreco
        }, "precoArtigo", function success(data) {
          
        }, function error(data) {

        }, function done(data) {

        });
      }*/

  funcaoSelect("includes/select.inc.php", "post", "json", "definicao", function success(data) {
    /*loadTabelaArtigo(data[1]["valor"], function callback(data) {
      let select = "";
      for (let i = 0; i < data.length; i++) {
        select += `
      <div class="col-md-3">
        <div class="card card-default">
          <div class="card-body button-nav cardArtigo" data-artigo="${data[i]["idArtigo"]}">
            <div class="row">
              <div class="col-md-12">
                <div class="form-group" style="margin: 0;">
                  <div class="row">
                    <div class="col-md-4">
                      <div class="row">
                        <div class="col-md-12">
                          <div class="form-group" style="margin-bottom: .2rem;">
                            <div style="width: 4rem; height: 4rem; border: 1px solid #e5e7eb; border-radius: .5rem; background-image: url(./images/artigo/${data[i]["imagem"] != null ? data[i]["imagem"] : "product.svg"}); background-size: contain;"></div>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-md-8" style="padding: 0;">
                      <div style="display: flex; justify-content: space-between;">
                        <small class="not-required">Preço</small><small class="not-required" style="color: ${data[i]["stock"] <= 0 ? "#dc3545" : "#28a745"};padding-right: .5rem;">${data[i]["stock"] <= 0 ? "Indisponível" : "Disponível"}</small>
                      </div>
                      <p style="font-size: 1rem; margin-bottom: 0;">${data[i]["precoComImposto"]}</p>
                      <small class="not-required">Stock: <span>${data[i]["stock"]}</span></small>
                    </div>
                  </div>
                </div>
                <p style="margin-bottom: 0;">${data[i]["nome"]}</p>
              </div>
            </div>
          </div>
        </div>
      </div>
        `;
      }
      $('#containerCardProduct').html(select);
    });*/
  }, function error(data) {

  }, function done(data) {});

  function loadTabelaArtigo(linhaPreco, callback) {
    let tabela;
    let iteracao = 0;
    funcaoSelect("includes/select.inc.php", "post", "json", "viewartigousuariofamilia", function success(data) {
      tabela = data;
      for (let i = 0; i < data.length; i++) {
        tabela[i].precoComImposto = 0;
        tabela[i].precoSemImposto = 0;
        tabela[i].stock = 0;
        funcaoQuerySelect("includes/querySelect.inc.php", "post", "json", {
          idArtigo: data[i]["idArtigo"],
          indice: linhaPreco
        }, "precoArtigo", function success(data) {
          if (data != null) {
            tabela[i].precoComImposto = data[0]['semImposto'];
            tabela[i].precoSemImposto = data[0]['comImposto'];
          } else {
            tabela[i].precoComImposto = 0;
            tabela[i].precoSemImposto = 0;
          }
          funcaoQuerySelect("includes/querySelect.inc.php", "post", "json", {
            idArtigo: tabela[i]["idArtigo"]
          }, "artigoStock", function success(data) {
            if (data != null) {
              tabela[i].stock = data[0]['qtdDisponivel'];
            } else {
              tabela[i].stock = 0;
            }
          }, function error(data) {

          }, function done(data) {

          });
        }, function error(data) {

        }, function done(data) {

        });
        iteracao = iteracao + 1;
      }
      if (iteracao == data.length) {
        setTimeout(function() {
          callback(tabela);
        }, 3000);
      }
    }, function error(data) {

    }, function done(data) {});
  }

  function detalhes(id) {
    funcaoQuerySelect("includes/querySelect.inc.php", "post", "json", {
      idEntidade: id
    }, "viewEntidade", function success(data) {
      console.log("CLIENTE: ", data);
      for (var key in data) {
        nomeModal.innerText = data[key]["nome"];
        codigoInfo.innerText = data[key]["idTipoUsuario"];
        nomeInfo.innerText = data[key]["nome"];
        notaInfo.innerText = data[key]["nota"];
      }
    }, function error(data) {

    }, function done(data) {

    });
  }
  botaoOutrasOpcoes(document.querySelectorAll(".btn-opcao"));
  linhaSelecionada("tabelaCliente", document.querySelector("#btnSelectCliente"));
  linhaSelecionada("tabelaArtigoListagem", document.querySelector("#btnSelectArtigo"));
  funcaoQuerySelect("includes/querySelect.inc.php", "post", "json", {
    idTipoEntidade: 2
  }, "viewEntidade", function success(data) {
    $("#tabelaCliente").DataTable({
      select: 'single',
      "aaData": data,
      "columns": [{
        data: "codigoEntidade"
      }, {
        data: "nome"
      }, {
        data: "nomeComercial"
      }, {
        data: "bi"
      }, {
        data: "nif"
      }, {
        data: "localidade"
      }, {
        data: "morada"
      }],
      columnDefs: [{
        targets: -1,
        orderable: false
      }],
      "responsive": true,
      "lengthChange": false,
      "autoWidth": false,
      "language": idiomaPortugues,
      lengthMenu: [
        [7, 25, 50, -1],
        [10, 25, 50, 'All']
      ],
    }).buttons().container().appendTo('#tabelaCliente_wrapper .col-md-6:eq(0)');
  }, function error(data) {

  }, function done(data) {

  });


  $(document).on("click", "#btn-preview", function(e) {
    e.preventDefault();
    $('#modal-updateTipoEntidade').modal('show');
  });

  $('#tabelaCliente').on('click', '.btn-more', function(e) {
    e.preventDefault();
    $('#modal-updateTipoEntidade').modal('show');
    detalhes($(this).closest('tr').find('td')[0].textContent);
  });

  let id = {
    idCodigoTaxa: 1
  }
  let tabela = "tipoUsuario";

  function updateLinha(id, tabela) {
    funcaoQuerySelect("includes/querySelect.inc.php", "post", "json", id, tabela, function success(data) {
      for (var key in data) {
        linha[1].innerText = data[key]["nome"];
        linha[2].innerText = data[key]["nota"];
      }
    }, function error(data) {

    }, function done(data) {

    });
  }

  function insertLinha(id, tabela) {
    funcaoQuerySelect("includes/querySelect.inc.php", "post", "json", id, tabela, function success(data) {
      for (var key in data) {
        var novaLinha = {
          idTipoUsuario: data[key]["idTipoUsuario"],
          nome: data[key]["nome"],
          nota: data[key]["nota"],
        };
        $('#tabelaCliente').DataTable().row.add(novaLinha).draw(false);
      }
    }, function error(data) {

    }, function done(data) {

    });
  }

  $('#btnSearchCliente').on("click", function(e) {
    e.preventDefault();
    $('#modal-cliente').modal('show');
  });

  function loadNovoId() {
    funcaoAutoIncrement("includes/autoIncrement.inc.php", "post", "json", "test1234", "tipoUsuario", "tu", function success(data) {
      codigo.innerText = data[0]["tu"];
    }, function error(data) {

    }, function done(data) {

    });
  }

  $(document).on("click", ".submit", function(e) {
    e.preventDefault();
    if (nome.value != '') {
      //tipoUsuario();
    }
  });

  $(document).on("click", "#btn", function(e) {
    e.preventDefault();
    doOpcao.innerText = "Novo Cliente";
    funcaoReload(document.querySelector(".submit"));

    $('#modal-formCliente').modal('show');
  });

  function tipoUsuario() {
    let dados = {
      nome: nome.value,
      nota: nota.value,
    };
    let tabela = "tipoUsuario";
    if (doOpcao.innerText == "Novo Cliente") {
      funcaoInsert("includes/insert.inc.php", "post", "json", tabela, dados, function success(data) {
        swal.fire({
          title: "Cadastro efectuado com sucesso!",
          text: "Cliente " + nome.value + " cadastrado!",
          confirmButtonText: 'Confirmar',
          confirmButtonColor: '#560085',
          icon: "success",
        });
        insertLinha({
          idTipoUsuario: data
        }, tabela);
        funcaoReload(document.querySelector(".submit"));
      }, function error(data) {
        swal.fire({
          title: "Erro ao cadastrar Cliente!",
          text: "Erro ao cadastrar Cliente: " + nome.value + " !",
          confirmButtonText: 'Confirmar',
          confirmButtonColor: '#560085',
          icon: "error",
        });
      }, function done(data) {

      });
    } else {
      funcaoUpdate("includes/update.inc.php", "post", "json", tabela, dados, {
        idTipoUsuario: codigo.innerText
      }, function success(data) {
        swal.fire({
          title: "Informações Actualizadas com sucesso!",
          text: "Cliente " + nome.value + ".",
          confirmButtonText: 'Confirmar',
          confirmButtonColor: '#560085',
          icon: "success",
        });
        updateLinha({
          idTipoUsuario: codigo.innerText
        }, tabela);
        funcaoReload(document.querySelector(".submit"));
      }, function error(data) {
        console.log("Erro: ", data);
        swal.fire({
          title: "Erro ao actualizar Cliente!",
          text: "Erro ao actualizar Cliente: " + nome.value + " !",
          confirmButtonText: 'Confirmar',
          confirmButtonColor: '#560085',
          icon: "error",
        });
      }, function done(data) {

      });
    }
  }

  $('#tabelaArtigoListagem').on('click', 'tbody td', function(e) {
    e.preventDefault();
    artigoSelecionado = $(this).closest('tr');
  });

  $('#tabelaArtigoListagem').on('dblclick', 'tbody td', function(e) {
    e.preventDefault();
    funcaoSearchArtigo($(this).closest('tr'));
    $('#modal-artigo').modal('hide');
  });

  $('#btnSelectArtigo').on('click', function(e) {
    e.preventDefault();
    funcaoSearchArtigo(artigoSelecionado);
    $('#modal-artigo').modal('hide');
  });

  $('#tabelaCliente').on('click', 'tbody td', function(e) {
    e.preventDefault();
    clienteSelecionado = $(this).closest('tr').find('td')[0].textContent;
  });

  $('#tabelaCliente').on('dblclick', 'tbody td', function(e) {
    e.preventDefault();
    funcaoSearchCliente($(this).closest('tr').find('td')[0].textContent);
    $('#modal-cliente').modal('hide');
  });

  $('#btnSelectCliente').on('click', function(e) {
    e.preventDefault();
    funcaoSearchCliente(clienteSelecionado);
    $('#modal-cliente').modal('hide');
  });


  function mesmoArtigoVerify(referencia) {

    for (let i = 0; i < referencia.length; i++) {
      if (referencia[i] !== "") {
        valores.push(referencia[i]);
      }
    }

    for (let i = 0; i < valores.length; i++) {
      for (let j = i + 1; j < valores.length; j++) {
        if (valores[i] === valores[j] && !valoresDuplicados.includes(valores[i])) {
          valoresDuplicados.push(valores[i]);
        }
      }
    }
    return valoresDuplicados;
  }

  $(document).ready(function() {
    funcaoSelect("includes/select.inc.php", "post", "json", "tipoEntidade", function success(data) {
      let select = "";
      select += "<option value='0'>Selecione Tipo de Entidade</option>";
      for (var key in data) {
        select += "<option value=" + data[key]['idTipoEntidade'] + ">" + data[key]['nome'] + "</option>";
      }
      $("#idTipoEntidade").html(select);
    }, function error(data) {

    }, function done(data) {
      $('#idTipoEntidade').attr('disabled', 'disabled');
      $('#idTipoEntidade').val(2);
      $('#idTipoEntidade').select2().trigger('change');
    });
    funcaoSelect("includes/select.inc.php", "post", "json", "definicao", function success(data) {
      let select = "";
      select += `<option value="0">Definição do Sistema</option>`;
      for (var key in data) {
        if (data[key]["idDefinicao"] == 1) {
          for (let i = 0; i < data[key]["valor"]; i++) {
            select += `<option value="${i + 1}">P.Venda (${i + 1})</option>`;
          }
        }
      }
      $("#linhaPrecoPredefinida").html(select);
    }, function error(data) {

    }, function done(data) {

    });
  });

  $('#tabelaCliente').on('click', '.btn-update', function(e) {
    e.preventDefault();
    linha = $(this).closest('tr').find('td');
    doOpcao.innerText = "Editar Cliente";
    resetForm(document.querySelector(".slidePage"));
    $('#modal-formCliente').modal('show');
    let id = $(this).closest('tr').find('td')[0].textContent;
    funcaoQuerySelect("includes/querySelect.inc.php", "post", "json", {
      idTipoUsuario: id
    }, "tipoUsuario", function success(data) {
      for (var key in data) {
        codigo.innerText = data[key]["idTipoUsuario"];

        if (data[key]["nome"] != "") {
          nome.value = data[key]["nome"];
        } else {
          nome.value = "";
        }

        if (data[key]["nota"] != "") {
          nota.value = data[key]["nota"];
        } else {
          nota.value = "";
        }
      }
    }, function error(data) {

    }, function done(data) {

    });
  });

  $('#tabelaCliente').on('click', '.btn-delete', function(e) {
    e.preventDefault();
    linha = $(this).closest('tr').find('td');
    let id = $(this).closest('tr').find('td')[0].textContent;
    let nome = $(this).closest('tr').find('td')[1].textContent;
    swal.fire({
        title: "Tem a certeza que pretende eliminar Cliente?",
        text: "Cliente: " + nome,
        icon: "warning",
        showCancelButton: true,
        confirmButtonText: 'Confirmar',
        confirmButtonColor: '#560085',
        cancelButtonText: 'Cancelar',
        cancelButtonColor: '#560085',
      })
      .then((result) => {
        if (result.isConfirmed) {
          funcaoDelete("includes/delete.inc.php", "post", "json", tabela, {
            idTipoUsuario: id
          }, function success(data) {
            console.log(data);
            swal.fire({
              title: "Cliente " + nome + " eliminado com sucesso!",
              icon: "success",
              confirmButtonText: 'Confirmar',
              confirmButtonColor: '#560085',
            });
            $('#tabelaCliente').DataTable().row(linha).remove().draw(false);
            funcaoReload(document.querySelector(".submit"));
          }, function error(data) {
            console.log(data);
            swal.fire({
              title: "Erro ao eliminar Cliente!",
              text: "Cliente associado a uma ou mais Documentos.",
              icon: "error",
              confirmButtonText: 'Confirmar',
              confirmButtonColor: '#560085',
            });
          }, function done(data) {

          });
        }
      });
  });
</script>
<script src="./javascript/validation.js"></script>