<?php
include("../gestor/gestao/classes/database.class.php");
include("../gestor/gestao/classes/configuracaoModel.class.php");

date_default_timezone_set("Africa/Luanda");
$modelo = new ConfiguracaoModel();
$rows = $modelo->listaConfig();
?>
<!DOCTYPE html>
<html lang="pt">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="../gestor/gestao/images/logo/favicon.png" rel="icon">
  <meta http-equiv="Content-Security-Policy" content="script-src 'self' 'unsafe-inline';">
  <link href="../gestor/gestao/images/logo/biocom.png" rel="icon">
  <title>BIOCOM | Cadastro Clientes</title>
  <link rel="stylesheet" href="../gestor/gestao/template/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
  <link rel="stylesheet" href="../gestor/gestao/template/plugins/datatables-responsive/css/responsive.bootstrap4.min.css">
  <link rel="stylesheet" href="../gestor/gestao/template/plugins/datatables-buttons/css/buttons.bootstrap4.min.css">
  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../gestor/gestao/template/plugins/fontawesome-free/css/all.min.css">
  <!-- daterange picker -->
  <link rel="stylesheet" href="../gestor/gestao/template/plugins/daterangepicker/daterangepicker.css">
  <!-- iCheck for checkboxes and radio inputs -->
  <link rel="stylesheet" href="../gestor/gestao/template/plugins/icheck-bootstrap/icheck-bootstrap.min.css">
  <!-- Bootstrap Color Picker -->
  <link rel="stylesheet" href="../gestor/gestao/template/plugins/bootstrap-colorpicker/css/bootstrap-colorpicker.min.css">
  <!-- Tempusdominus Bootstrap 4 -->
  <link rel="stylesheet" href="../gestor/gestao/template/plugins/tempusdominus-bootstrap-4/css/tempusdominus-bootstrap-4.min.css">
  <!-- Select2 -->
  <link rel="stylesheet" href="../gestor/gestao/template/plugins/select2/css/select2.min.css">
  <link rel="stylesheet" href="../gestor/gestao/template/plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css">
  <!-- Bootstrap4 Duallistbox -->
  <link rel="stylesheet" href="../gestor/gestao/template/plugins/bootstrap4-duallistbox/bootstrap-duallistbox.min.css">
  <!-- BS Stepper -->
  <link rel="stylesheet" href="../gestor/gestao/template/plugins/bs-stepper/css/bs-stepper.min.css">
  <!-- dropzonejs -->
  <link rel="stylesheet" href="../gestor/gestao/template/plugins/dropzone/min/dropzone.min.css">
  <link rel="stylesheet" href="../gestor/gestao/template/plugins/toastr/toastr.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="../gestor/gestao/template/dist/css/adminlte.min.css">
  <link rel="stylesheet" href="../gestor/gestao/template/dist/css/style.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" integrity="sha512-KfkfwYDsLkIlwQp6LFnl8zNdLGxu9YAA1QvwINks4PhcElQSvqcyVLLD9aMhXd13uQjoXtEKNosOWaZqXgel0g==" crossorigin="anonymous" referrerpolicy="no-referrer" />
  <script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>

  <style>
    .toast-header {
      color: white;
      background-color: #55127c;
      border-bottom: none;
    }

    .toast-body {
      color: white;
      background-color: #55127c;
    }

    .toast {
      max-width: 450px;
      margin: .8rem;
    }

    .swal2-html-container {
      padding: .5rem !important;
    }
  </style>
</head>

<body class="hold-transition layout-top-nav">
  <?php

  if (isset($_GET["processo"])) {
  ?>
    <div class="content-wrapper">
      <!-- Content Header (Page header) -->
      <section class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6">
              <h4>REGISTO DE CLIENTES - BIOCOM</h4>
            </div>
          </div>
        </div><!-- /.container-fluid -->
      </section>

      <!-- Main content -->
      <section class="content">
        <div class="container-fluid">
          <div class="row">
            <div class="col-md-3">
              <div class="card card-primary card-outline" style="border-top: 3px solid #7fbd44;">
                <div class="card-body box-profile">
                  <div class="text-center">
                    <div class="profile-user-img img-fluid img-circle image-info-profile" style="display: flex; justify-content: center; align-items: center; background-image: url(../gestor/gestao/images/logo/biocom.png); border-color: #ad7d2f; background-size: contain;" alt="User profile picture">
                    </div>
                  </div>
                </div>
                <!-- /.card-body -->
              </div>
              <div class="card card-primary">
                <div class="card-header" style="background-color: #7fbd44;">
                  <h3 class="card-title">Productos da Biocom que tenciona adquirir</h3>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                  <div class="form-group" style="margin-bottom: 0;">
                    <div class="custom-control custom-checkbox">
                      <input class="custom-control-input" type="checkbox" id="opAcucar50" value="0" disabled>
                      <label for="opAcucar50" class="custom-control-label">Açúcar de 50KG</label>
                    </div>
                  </div>

                  <hr>

                  <div class="form-group" style="margin-bottom: 0;">
                    <div class="custom-control custom-checkbox">
                      <input class="custom-control-input" type="checkbox" id="opAcucar1" value="0" disabled>
                      <label for="opAcucar1" class="custom-control-label">Açúcar de 1KG</label>
                    </div>
                  </div>

                  <hr>

                  <div class="custom-control custom-checkbox">
                    <input class="custom-control-input" type="checkbox" id="opAlcool" value="0" disabled>
                    <label for="opAlcool" class="custom-control-label">Álcool Neutro</label>
                  </div>

                  <hr>

                  <div class="custom-control custom-checkbox">
                    <input class="custom-control-input" type="checkbox" id="opLab" value="0" disabled>
                    <label for="opLab" class="custom-control-label">Análises Laboratoriais</label>
                  </div>

                  <hr>
                  <div class="input-group">
                    <div class="input-group-prepend">
                      <span class="input-group-text">
                        <input type="checkbox" id="opOutro" value="0" disabled>
                      </span>
                    </div>
                    <input type="text" class="form-control" placeholder="Outro" id="outro" disabled>
                  </div>

                  <!--<hr>


                <a id="downloadForm" href="DueDelligence.docx" class="btn btn-primary btn-block" style="background-color: #55127c; border-color: #55127c;" download><b>Baixar Formulário</b></a>-->
                </div>
                <!-- /.card-body -->
              </div>
              <!-- /.card -->
            </div>
            <!-- /.col -->
            <div class="col-md-9">
              <div class="card card-default">
                <div class="card-header">
                  <h3 class="card-title">
                    <div class="alert alert-info alert-dismissible" style="background-color: #55127c; border-color: #55127c; margin: 0;">
                      A Biocom agradece o vosso interesse em nossos produtos. Para se tornar um cliente Biocom é necessário realizar o cadastro de vossa empresa, preenchendo o formulário a seguir. Após a análise dos vossos documentos, caso esteja tudo em conformidade, entraremos em contacto.
                    </div>
                  </h3>

                </div>
                <div class="card-body">
                  <div class="tab-content">
                    <div class="active tab-pane" id="informacao">
                      <div class="row">
                        <div class="col-md-4">
                          <div class="form-group margem" style="margin-bottom: 0;">
                            <small class="required">Nome da Empresa (Conforme a Certidão Comercial)</small>
                            <div class="input-group mb-3 field" style="margin-bottom: 0 !important;">
                              <input type="text" class="form-control" placeholder="Nome da Empresa (Conforme a Certidão Comercial)" name="nomeEmpresa" id="nomeEmpresa" disabled>
                              <div class="input-group-append">
                                <div class="input-group-text">
                                  <span class="fas fa-signature"></span>
                                </div>
                              </div>
                            </div>
                            <small>Mensagem de erro</small>
                          </div>
                          <div class="form-group margem" style="margin-bottom: 0;">
                            <small class="required">NIF da Empresa</small>
                            <div class="input-group mb-3 field" style="margin-bottom: 0 !important;">
                              <input type="text" class="form-control" placeholder="NIF (Número de Identificação Fiscal) da Empresa" name="nif" id="nif" disabled>
                              <div class="input-group-append">
                                <div class="input-group-text">
                                  <span class="fas fa-id-card"></span>
                                </div>
                              </div>
                            </div>
                            <small>Mensagem de erro</small>
                          </div>
                        </div>
                        <div class="col-md-4">
                          <div class="form-group margem" style="margin-bottom: 0;">
                            <small class="required">Telefone para contacto (Principal)</small>
                            <div class="input-group mb-3 field" style="margin-bottom: 0 !important;">
                              <input type="text" class="form-control" placeholder="Telefone para contacto (Principal)" name="telefone" id="telefone" data-inputmask="'mask': ['(+244) 999-999-999']" data-mask disabled>
                              <div class="input-group-append">
                                <div class="input-group-text">
                                  <span class="fas fa-phone"></span>
                                </div>
                              </div>
                            </div>
                            <small>Mensagem de erro</small>
                          </div>
                          <div class="form-group margem" style="margin-bottom: 0;">
                            <small class="required">Telefone para contacto Alternativo</small>
                            <div class="input-group mb-3 field" style="margin-bottom: 0 !important;">
                              <input type="text" class="form-control" placeholder="Telefone para contacto (Alternativo)" name="telefoneAlternativo" id="telefoneAlternativo" data-inputmask="'mask': ['(+244) 999-999-999']" data-mask disabled>
                              <div class="input-group-append">
                                <div class="input-group-text">
                                  <span class="fas fa-phone"></span>
                                </div>
                              </div>
                            </div>
                            <small>Mensagem de erro</small>
                          </div>
                        </div>
                        <div class="col-md-4">
                          <div class="form-group margem" style="margin-bottom: 0;">
                            <small class="required">Nome da pessoa de contacto</small>
                            <div class="input-group mb-3 field" style="margin-bottom: 0 !important;">
                              <input type="text" class="form-control" placeholder="Nome da pessoa de contacto" name="nomePessoaContacto" id="nomePessoaContacto" disabled>
                              <div class="input-group-append">
                                <div class="input-group-text">
                                  <span class="fas fa-user-tie"></span>
                                </div>
                              </div>
                            </div>
                            <small>Mensagem de erro</small>
                          </div>
                          <div class="form-group margem" style="margin-bottom: 0;">
                            <small class="required">E-mail para contacto</small>
                            <div class="input-group mb-3 field" style="margin-bottom: 0 !important;">
                              <input type="text" class="form-control" placeholder="E-mail para contacto" name="email" id="email" disabled>
                              <div class="input-group-append">
                                <div class="input-group-text">
                                  <span class="fas fa-envelope"></span>
                                </div>
                              </div>
                            </div>
                            <small>Mensagem de erro</small>
                          </div>
                        </div>
                        <!-- /.col -->
                      </div>
                      <div class="row">
                        <div class="col-md-4">
                          <div class="form-group">
                            <small class="required">Alvará Comercial (Actualizado)</small>
                            <div class="input-group">
                              <div class="custom-file">
                                <input type="file" class="custom-file-input" id="alvara" disabled>
                                <label class="custom-file-label" for="alvara">Escolher Ficheiro</label>
                              </div>
                            </div>
                            <small>Mensagem de erro</small>
                          </div>
                          <div class="form-group">
                            <small class="required">Diário da República (Completo)</small>
                            <div class="input-group">
                              <div class="custom-file">
                                <input type="file" class="custom-file-input" id="diario" disabled>
                                <label class="custom-file-label" for="diario">Escolher Ficheiro</label>
                              </div>
                            </div>
                            <small>Mensagem de erro</small>
                          </div>
                        </div>
                        <div class="col-md-4">
                          <div class="form-group">
                            <small class="required">NIF AGT (Cópia do documento original ou cartão)</small>
                            <div class="input-group">
                              <div class="custom-file">
                                <input type="file" class="custom-file-input" id="nifAgt" disabled>
                                <label class="custom-file-label" for="nifAgt">Escolher Ficheiro</label>
                              </div>
                            </div>
                            <small>Mensagem de erro</small>
                          </div>
                          <div class="form-group">
                            <small class="required">Responsável da empresa (BI/Cartão de Residente/Passaporte)</small>
                            <div class="input-group">
                              <div class="custom-file">
                                <input type="file" class="custom-file-input" id="responsavelDoc" disabled>
                                <label class="custom-file-label" for="responsavelDoc">Escolher Ficheiro</label>
                              </div>
                            </div>
                            <small>Mensagem de erro</small>
                          </div>
                        </div>
                        <div class="col-md-4">
                          <div class="form-group">
                            <small class="required">Certidão Comercial (Data de emissão com menos de 6 meses)</small>
                            <div class="input-group">
                              <div class="custom-file">
                                <input type="file" class="custom-file-input" id="certidao" disabled>
                                <label class="custom-file-label" for="certidao">Escolher Ficheiro</label>
                              </div>
                            </div>
                            <small>Mensagem de erro</small>
                          </div>
                          <div class="form-group">
                            <small class="not-required">Procuração (Cópia da procuração - quando aplicável)</small>
                            <div class="input-group">
                              <div class="custom-file">
                                <input type="file" class="custom-file-input" id="procuracao" disabled>
                                <label class="custom-file-label" for="procuracao">Escolher Ficheiro</label>
                              </div>
                            </div>
                            <small>Mensagem de erro</small>
                          </div>
                        </div>
                        <div class="col-md-12">
                          <div class="form-group">
                            <button type="submit" name="btn-submit" id="btn-submit" class="btn btn-block btn-primary" style="background-color: #ad7d2f; border-color: #ad7d2f;">Actualizar dados Empresa</button>
                          </div>
                        </div>
                      </div>
                    </div>
                    <!-- /.tab-pane -->
                  </div>
                  <!-- /.tab-content -->
                </div><!-- /.card-body -->
                <div class="card-footer">
                  <div class="col-md-12" style="padding: .6rem;">
                    Campos com asterisco (<span style="color: red;">*</span>) são campos de preenchimento obrigatório.
                  </div>
                </div>
              </div>
              <!-- /.card -->
            </div>
            <!-- /.col -->
          </div>
          <!-- /.row -->
        </div><!-- /.container-fluid -->
      </section>
      <!-- /.content -->
    </div>
  <?php
  } else {
  ?>
    <div class="content-wrapper">
      <!-- Content Header (Page header) -->
      <section class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6">
              <h4>REGISTO DE CLIENTES - BIOCOM</h4>
            </div>
          </div>
        </div><!-- /.container-fluid -->
      </section>

      <!-- Main content -->
      <section class="content">
        <div class="container-fluid">
          <div class="row">
            <div class="col-md-3">
              <div class="card card-primary card-outline" style="border-top: 3px solid #7fbd44;">
                <div class="card-body box-profile">
                  <div class="text-center">
                    <div class="profile-user-img img-fluid img-circle image-info-profile" style="display: flex; justify-content: center; align-items: center; background-image: url(../gestor/gestao/images/logo/biocom.png); border-color: #ad7d2f; background-size: contain;" alt="User profile picture">
                    </div>
                  </div>
                </div>
                <!-- /.card-body -->
              </div>
              <div class="card card-primary">
                <div class="card-header" style="background-color: #7fbd44;">
                  <h3 class="card-title">Productos da Biocom que tenciona adquirir</h3>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                  <div class="form-group" style="margin-bottom: 0;">
                    <div class="custom-control custom-checkbox">
                      <input class="custom-control-input" type="checkbox" id="opAcucar50" value="0">
                      <label for="opAcucar50" class="custom-control-label">Açúcar de 50KG</label>
                    </div>
                  </div>

                  <hr>

                  <div class="form-group" style="margin-bottom: 0;">
                    <div class="custom-control custom-checkbox">
                      <input class="custom-control-input" type="checkbox" id="opAcucar1" value="0">
                      <label for="opAcucar1" class="custom-control-label">Açúcar de 1KG</label>
                    </div>
                  </div>

                  <hr>

                  <div class="custom-control custom-checkbox">
                    <input class="custom-control-input" type="checkbox" id="opAlcool" value="0">
                    <label for="opAlcool" class="custom-control-label">Álcool Neutro</label>
                  </div>

                  <hr>

                  <div class="custom-control custom-checkbox">
                    <input class="custom-control-input" type="checkbox" id="opLab" value="0">
                    <label for="opLab" class="custom-control-label">Análises Laboratoriais</label>
                  </div>

                  <hr>
                  <div class="input-group">
                    <div class="input-group-prepend">
                      <span class="input-group-text">
                        <input type="checkbox" id="opOutro" value="0">
                      </span>
                    </div>
                    <input type="text" class="form-control" placeholder="Outro" id="outro" disabled>
                  </div>

                  <!--<hr>


                <a id="downloadForm" href="DueDelligence.docx" class="btn btn-primary btn-block" style="background-color: #55127c; border-color: #55127c;" download><b>Baixar Formulário</b></a>-->
                </div>
                <!-- /.card-body -->
              </div>
              <!-- /.card -->
            </div>
            <!-- /.col -->
            <div class="col-md-9">
              <div class="card card-default">
                <div class="card-header">
                  <h3 class="card-title">
                    <div class="alert alert-info alert-dismissible" style="background-color: #55127c; border-color: #55127c; margin: 0;">
                      A Biocom agradece o vosso interesse em nossos produtos. Para se tornar um cliente Biocom é necessário realizar o cadastro de vossa empresa, preenchendo o formulário a seguir. Após a análise dos vossos documentos, caso esteja tudo em conformidade, entraremos em contacto.
                    </div>
                  </h3>

                </div>
                <div class="card-body">
                  <div class="tab-content">
                    <div class="active tab-pane" id="informacao">
                      <div class="row">
                        <div class="col-md-4">
                          <div class="form-group margem" style="margin-bottom: 0;">
                            <small class="required">Nome da Empresa (Conforme a Certidão Comercial)</small>
                            <div class="input-group mb-3 field" style="margin-bottom: 0 !important;">
                              <input type="text" class="form-control" placeholder="Nome da Empresa (Conforme a Certidão Comercial)" name="nomeEmpresa" id="nomeEmpresa">
                              <div class="input-group-append">
                                <div class="input-group-text">
                                  <span class="fas fa-signature"></span>
                                </div>
                              </div>
                            </div>
                            <small>Mensagem de erro</small>
                          </div>
                          <div class="form-group margem" style="margin-bottom: 0;">
                            <small class="required">NIF da Empresa</small>
                            <div class="input-group mb-3 field" style="margin-bottom: 0 !important;">
                              <input type="text" class="form-control" placeholder="NIF (Número de Identificação Fiscal) da Empresa" name="nif" id="nif">
                              <div class="input-group-append">
                                <div class="input-group-text">
                                  <span class="fas fa-id-card"></span>
                                </div>
                              </div>
                            </div>
                            <small>Mensagem de erro</small>
                          </div>
                        </div>
                        <div class="col-md-4">
                          <div class="form-group margem" style="margin-bottom: 0;">
                            <small class="required">Telefone para contacto (Principal)</small>
                            <div class="input-group mb-3 field" style="margin-bottom: 0 !important;">
                              <input type="text" class="form-control" placeholder="Telefone para contacto (Principal)" name="telefone" id="telefone" data-inputmask="'mask': ['(+244) 999-999-999']" data-mask>
                              <div class="input-group-append">
                                <div class="input-group-text">
                                  <span class="fas fa-phone"></span>
                                </div>
                              </div>
                            </div>
                            <small>Mensagem de erro</small>
                          </div>
                          <div class="form-group margem" style="margin-bottom: 0;">
                            <small class="required">Telefone para contacto Alternativo</small>
                            <div class="input-group mb-3 field" style="margin-bottom: 0 !important;">
                              <input type="text" class="form-control" placeholder="Telefone para contacto (Alternativo)" name="telefoneAlternativo" id="telefoneAlternativo" data-inputmask="'mask': ['(+244) 999-999-999']" data-mask>
                              <div class="input-group-append">
                                <div class="input-group-text">
                                  <span class="fas fa-phone"></span>
                                </div>
                              </div>
                            </div>
                            <small>Mensagem de erro</small>
                          </div>
                        </div>
                        <div class="col-md-4">
                          <div class="form-group margem" style="margin-bottom: 0;">
                            <small class="required">Nome da pessoa de contacto</small>
                            <div class="input-group mb-3 field" style="margin-bottom: 0 !important;">
                              <input type="text" class="form-control" placeholder="Nome da pessoa de contacto" name="nomePessoaContacto" id="nomePessoaContacto">
                              <div class="input-group-append">
                                <div class="input-group-text">
                                  <span class="fas fa-user-tie"></span>
                                </div>
                              </div>
                            </div>
                            <small>Mensagem de erro</small>
                          </div>
                          <div class="form-group margem" style="margin-bottom: 0;">
                            <small class="required">E-mail para contacto</small>
                            <div class="input-group mb-3 field" style="margin-bottom: 0 !important;">
                              <input type="text" class="form-control" placeholder="E-mail para contacto" name="email" id="email">
                              <div class="input-group-append">
                                <div class="input-group-text">
                                  <span class="fas fa-envelope"></span>
                                </div>
                              </div>
                            </div>
                            <small>Mensagem de erro</small>
                          </div>
                        </div>
                        <!-- /.col -->
                      </div>
                      <div class="row">
                        <div class="col-md-4">
                          <div class="form-group">
                            <small class="required">Alvará Comercial (Actualizado)</small>
                            <div class="input-group">
                              <div class="custom-file">
                                <input type="file" class="custom-file-input" id="alvara">
                                <label class="custom-file-label" for="alvara">Escolher Ficheiro</label>
                              </div>
                            </div>
                            <small>Mensagem de erro</small>
                          </div>
                          <div class="form-group">
                            <small class="required">Diário da República (Completo)</small>
                            <div class="input-group">
                              <div class="custom-file">
                                <input type="file" class="custom-file-input" id="diario">
                                <label class="custom-file-label" for="diario">Escolher Ficheiro</label>
                              </div>
                            </div>
                            <small>Mensagem de erro</small>
                          </div>
                        </div>
                        <div class="col-md-4">
                          <div class="form-group">
                            <small class="required">NIF AGT (Cópia do documento original ou cartão)</small>
                            <div class="input-group">
                              <div class="custom-file">
                                <input type="file" class="custom-file-input" id="nifAgt">
                                <label class="custom-file-label" for="nifAgt">Escolher Ficheiro</label>
                              </div>
                            </div>
                            <small>Mensagem de erro</small>
                          </div>
                          <div class="form-group">
                            <small class="required">Responsável da empresa (BI/Cartão de Residente/Passaporte)</small>
                            <div class="input-group">
                              <div class="custom-file">
                                <input type="file" class="custom-file-input" id="responsavelDoc">
                                <label class="custom-file-label" for="responsavelDoc">Escolher Ficheiro</label>
                              </div>
                            </div>
                            <small>Mensagem de erro</small>
                          </div>
                        </div>
                        <div class="col-md-4">
                          <div class="form-group">
                            <small class="required">Certidão Comercial (Data de emissão com menos de 6 meses)</small>
                            <div class="input-group">
                              <div class="custom-file">
                                <input type="file" class="custom-file-input" id="certidao">
                                <label class="custom-file-label" for="certidao">Escolher Ficheiro</label>
                              </div>
                            </div>
                            <small>Mensagem de erro</small>
                          </div>
                          <div class="form-group">
                            <small class="not-required">Procuração (Cópia da procuração - quando aplicável)</small>
                            <div class="input-group">
                              <div class="custom-file">
                                <input type="file" class="custom-file-input" id="procuracao">
                                <label class="custom-file-label" for="procuracao">Escolher Ficheiro</label>
                              </div>
                            </div>
                            <small>Mensagem de erro</small>
                          </div>
                        </div>
                        <div class="col-md-12">
                          <div class="form-group">
                            <button type="submit" name="btn-submit" id="btn-submit" class="btn btn-block btn-primary" style="background-color: #ad7d2f; border-color: #ad7d2f;">Cadastrar Empresa</button>
                          </div>
                        </div>
                      </div>
                    </div>
                    <!-- /.tab-pane -->
                  </div>
                  <!-- /.tab-content -->
                </div><!-- /.card-body -->
                <div class="card-footer">
                  <div class="col-md-12" style="padding: .6rem;">
                    Campos com asterisco (<span style="color: red;">*</span>) são campos de preenchimento obrigatório.
                  </div>
                </div>
              </div>
              <!-- /.card -->
            </div>
            <!-- /.col -->
          </div>
          <!-- /.row -->
        </div><!-- /.container-fluid -->
      </section>
      <!-- /.content -->
    </div>
  <?php
  }
  ?>

  <!-- /.login-box -->
  <!-- jQuery -->

  <script src="../gestor/gestao/template/plugins/jquery/jquery.min.js"></script>
  <!-- Bootstrap 4 -->
  <script src="../gestor/gestao/template/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
  <!-- AdminLTE App -->
  <script src="../gestor/gestao/template/dist/js/adminlte.min.js"></script>
  <script src="../gestor/gestao/template/plugins/toastr/toastr.min.js"></script>
  <script src="../gestor/gestao/template/plugins/select2/js/select2.full.min.js"></script>
  <script src="../gestor/gestao/template/plugins/inputmask/jquery.inputmask.min.js"></script>
  <script src="../gestor/gestao/template/plugins/bs-custom-file-input/bs-custom-file-input.min.js"></script>
  <script src="../gestor/js/sweetalert.min.js"></script>
  <script src="../gestor/js/sweetalert2.min.js"></script>
  <script src="../gestor/js/sendEmail.js"></script>
  <script src="https://smtpjs.com/v3/smtp.js">
  </script>
  <script>
    let idClienteActualizar;
    let nifClienteActualizar;
    let nomeEmpresaActualizar;
    let codigoActualizar;
    let verifyConfirm = 0;
    let idClienteConfirm;
    let emailConfirm;
    let telefoneConfirm;
    let nifConfirm;
    let nomeEmpresaConfirm;

    let caminhoEmail;
    let idClienteEmail;
    let nifEmail;
    let nomeEmpresaEmail;
    let telefoneEmail;
    let telefoneAlternativoEmail;
    let nomePessoaContactoEmail;
    let enderecoEmail;
    let dataCadastroEmail;
    let opAcucar50Email;
    let opAcucar1Email;
    let opAlcoolEmail;
    let opLabEmail;
    let outroEmail;
    let codigoEmail;

    let resizedImage;

    $('[data-mask]').inputmask();

    /*$(document).on("keyup", "#emailConfirmacao", function(e) {
      e.preventDefault();
      emailConfirmacao.addEventListener("keyup", function() {
        let small = emailConfirmacao.parentElement.parentElement.querySelectorAll("small")[1];
        if (emailConfirmacao.value === '') {
          emailConfirmacaoWarning(small);
        } else if (!emailRegExp.test(emailConfirmacao.value)) {
          emailConfirmacaoInvalid(small);
        } else {
          if (emailConfirmacao.value === emailConfirm) {
            emailConfirmacaoValid(small);
          } else {
            emailConfirmacaoInvalidConfirm(small);
          }
        }
      });
    });

    $(document).on("keyup", "#telefoneConfirmacao", function(e) {
      e.preventDefault();
      telefoneConfirmacao.addEventListener("keyup", function() {
        let small = telefoneConfirmacao.parentElement.parentElement.querySelectorAll("small")[1];
        if (telefoneConfirmacao.value === '') {
          telefoneConfirmacaoWarning(small);
        } else {
          if (telefoneConfirmacao.value.split(' ')[1].replace(/\-/g, '') === telefoneConfirm) {
            telefoneConfirmacaoValid(small);
          } else {
            telefoneConfirmacaoInvalidConfirm(small);
          }
        }
      });
    });

    $(document).on("click", "#btn-confirm", function(e) {
      e.preventDefault();
      let smallEmailConfirmacao = emailConfirmacao.parentElement.parentElement.querySelectorAll("small")[1];
      let smallTelefoneConfirmacao = telefoneConfirmacao.parentElement.parentElement.querySelectorAll("small")[1];

      if (emailConfirmacao.value === '') {
        emailConfirmacaoWarning(smallEmailConfirmacao);
      } else if (!emailRegExp.test(emailConfirmacao.value)) {
        emailConfirmacaoInvalid(smallEmailConfirmacao);
      } else {
        if (emailConfirmacao.value === emailConfirm) {
          emailConfirmacaoValid(smallEmailConfirmacao);
        } else {
          emailConfirmacaoInvalidConfirm(smallEmailConfirmacao);
        }
      }
      if (telefoneConfirmacao.value === '') {
        telefoneConfirmacaoWarning(smallTelefoneConfirmacao);
      } else {
        if (telefoneConfirmacao.value.split(' ')[1].replace(/\-/g, '') === telefoneConfirm) {
          telefoneConfirmacaoValid(smallTelefoneConfirmacao);
        } else {
          telefoneConfirmacaoInvalidConfirm(smallTelefoneConfirmacao);
        }
      }

      if (formulario.value == '') {
        formulario.className = "form-control is-warning";
        smallFormulario.style.visibility = "visible";
        smallFormulario.style.color = "#ffc107";
        smallFormulario.innerText = "Campo formulário preenchido é Obrigatório!";
        btnConfirm.setAttribute('disabled', 'disabled');
      } else {
        if (formulario.value.split('.').pop() != "pdf" && formulario.value.split('.').pop() != "jpg" && formulario.value.split('.').pop() != "jpeg" && formulario.value.split('.').pop() != "png" && formulario.value.split('.').pop() != "txt" && formulario.value.split('.').pop() != "docx") {
          formulario.className = "form-control is-invalid";
          smallFormulario.style.visibility = "visible";
          smallFormulario.style.color = "#dc3545";
          smallFormulario.innerText = "Apenas documentos com extensão: Pdf, Jpg, Jpeg, Png, txt ou Docx!";
          btnConfirm.setAttribute('disabled', 'disabled');
        } else {
          formulario.className = "form-control is-valid";
          btnConfirm.removeAttribute('disabled');
          smallFormulario.style.visibility = "hidden";
        }
      }
    });*/

    $(document).on("click", "#opAcucar50", function(e) {
      if (this.checked) {
        this.value = 1;
      } else {
        this.value = 0;
      }
    });

    $(document).on("click", "#opAcucar1", function(e) {
      if (this.checked) {
        this.value = 1;
      } else {
        this.value = 0;
      }
    });

    $(document).on("click", "#opAlcool", function(e) {
      if (this.checked) {
        this.value = 1;
      } else {
        this.value = 0;
      }
    });

    $(document).on("click", "#opLab", function(e) {
      if (this.checked) {
        this.value = 1;
      } else {
        this.value = 0;
      }
    });

    $(document).on("click", "#opOutro", function(e) {
      if (this.checked) {
        this.value = 1;
        outro.removeAttribute('disabled');
      } else {
        this.value = 0;
        outro.setAttribute('disabled', 'disabled');
        outro.value = "";
      }
    });

    $(function() {
      bsCustomFileInput.init();
    });

    /*$(document).ready(function() {
      setTimeout(function() {
        toastr.info('Será enviado um código e um link para o endereço de e-mail para confirmar o seu cadastro.')
      }, 2000);
    });*/

    $(function() {
      //Initialize Select2 Elements
      $('.select2').select2()

      //Initialize Select2 Elements
      $('.select2bs4').select2({
        theme: 'bootstrap4'
      })
    })

    $(function() {
      $('.toastrDefaultSuccess').click(function() {
        toastr.success('Lorem ipsum dolor sit amet, consetetur sadipscing elitr.')
      });
      $('.toastrDefaultInfo').click(function() {
        toastr.info('Lorem ipsum dolor sit amet, consetetur sadipscing elitr.')
      });
      $('.toastrDefaultError').click(function() {
        toastr.error('Lorem ipsum dolor sit amet, consetetur sadipscing elitr.')
      });
      $('.toastrDefaultWarning').click(function() {
        toastr.warning('Lorem ipsum dolor sit amet, consetetur sadipscing elitr.')
      });
    });

    $(document).on("click", "#btn", function(e) {
      var elemento = document.querySelectorAll(".custom-file input");

      for (let i = 0; i < elemento.length; i++) {
        console.log("Esses: ", elemento[i].parentElement.parentElement.parentElement.querySelectorAll("small")[0].innerText.split('(')[0]);
      }
    });

    async function ficheiros(elemento, idCliente, codigo) {
      await correr(elemento, idCliente, codigo);
      enviarEmail(idCliente, codigo);
    }

    function correr(elemento, idCliente, codigo) {
      for (let i = 0; i < elemento.length; i++) {
        if (elemento[i].files[0] != undefined) {
          linha(elemento[i], idCliente, codigo);
        }
      }
    }

    async function executar(elemento, idCliente, codigo) {
      await ficheiros(elemento, idCliente, codigo);

    }

    function createZip(data, idCliente, codigo) {
      $.ajax({
        url: "../gestor/gestao/includes/read/queryCliente.inc.php",
        type: "post",
        dataType: "json",
        data: {
          idCliente: idCliente
        },
        success: function(data) {
          $.ajax({
            url: "../gestor/gestao/includes/create/zip.inc.php",
            type: "post",
            data: {
              caminho: "../../documento/",
              nomeEmpresa: data[0]["nomeEmpresa"],
              nif: data[0]["nif"],
            },
            success: function(data) {

            }
          }).done(function() {});
        }
      });
    }

    function enviarEmail(idCliente, codigo) {
      $.ajax({
        url: "../gestor/gestao/includes/read/queryCliente.inc.php",
        type: "post",
        dataType: "json",
        data: {
          idCliente: idCliente
        },
        success: function(data) {
          if (data[0]['opAcucar50'] == 0) {
            opAcucar50Email = null;
          } else {
            opAcucar50Email = "Açúcar de 50KG";
          }

          if (data[0]['opAcucar1'] == 0) {
            opAcucar1Email = null;
          } else {
            opAcucar1Email = "Açúcar de 1KG";
          }

          if (data[0]['opAlcool'] == 0) {
            opAlcoolEmail = null;
          } else {
            opAlcoolEmail = "Álcool Neutro";
          }

          if (data[0]['opLab'] == 0) {
            opLabEmail = null;
          } else {
            opLabEmail = "Análises Laboratoriais";
          }

          if (data[0]['outro'] == null) {
            outroEmail = null;
          } else {
            outroEmail = data[0]["outro"];
          }

          $.ajax({
            url: "../gestor/gestao/includes/create/email.inc.php",
            type: "post",
            data: {
              caminho: "../../documento/",
              idCliente: data[0]["idCliente"],
              nif: data[0]["nif"],
              nomeEmpresa: data[0]["nomeEmpresa"],
              telefone: data[0]["telefone"],
              telefoneAlternativo: data[0]["telefoneAlternativo"],
              nomePessoaContacto: data[0]["nomePessoaContacto"],
              email: data[0]["email"],
              dataCadastro: data[0]["dataCadastro"],
              opAcucar50: opAcucar50Email,
              opAcucar1: opAcucar1Email,
              opAlcool: opAlcoolEmail,
              opLab: opLabEmail,
              outro: outroEmail,
              codigo: codigo,
            },
            success: function(data) {
              Swal.fire({
                title: 'Obrigado, o seu pedido foi enviado!',
                text: 'Informações foram enviadas ao e-mail: ' + email.value + '.',
                allowOutsideClick: false,
                confirmButtonText: 'Confirmar',
                confirmButtonColor: "#55127c",
                icon: 'success'
              }).then(() => {
                nif.value = "";
                nif.className = "form-control";
                nif.parentElement.parentElement.querySelectorAll(".input-group-text")[0].style.borderColor = "#ced4da";
                nomeEmpresa.value = "";
                nomeEmpresa.className = "form-control";
                nomeEmpresa.parentElement.parentElement.querySelectorAll(".input-group-text")[0].style.borderColor = "#ced4da";
                telefone.value = "";
                telefone.className = "form-control";
                telefone.parentElement.parentElement.querySelectorAll(".input-group-text")[0].style.borderColor = "#ced4da";
                telefoneAlternativo.value = "";
                telefoneAlternativo.className = "form-control";
                telefoneAlternativo.parentElement.parentElement.querySelectorAll(".input-group-text")[0].style.borderColor = "#ced4da";
                nomePessoaContacto.value = "";
                nomePessoaContacto.className = "form-control";
                nomePessoaContacto.parentElement.parentElement.querySelectorAll(".input-group-text")[0].style.borderColor = "#ced4da";
                email.value = "";
                email.className = "form-control";
                email.parentElement.parentElement.querySelectorAll(".input-group-text")[0].style.borderColor = "#ced4da";

                opAcucar50.checked = false;
                opAcucar1.checked = false;
                opAlcool.checked = false;
                opLab.checked = false;
                opOutro.checked = false;
                outro.value = "";
                outro.setAttribute("disabled", "disabled");

                var elemento = document.querySelectorAll(".custom-file input");

                for (let i = 0; i < elemento.length; i++) {
                  elemento[i].value = "";
                  var customLabel = elemento[i].nextElementSibling;
                  if (customLabel) {
                    customLabel.innerHTML = 'Escolher Ficheiro';
                  }
                }

                bsCustomFileInput.init();
              });
              console.log(data);
            }
          });
        }

      });
    }

    function linha(elemento, idCliente, codigo) {
      let form_data = new FormData();
      form_data.append('id', idCliente);
      form_data.append('nomeDocumento', elemento.parentElement.parentElement.parentElement.querySelectorAll("small")[0].innerText.split(' (')[0]);
      form_data.append('nif', nif.value);
      form_data.append('nomeEmpresa', nomeEmpresa.value);
      form_data.append('ficheiro', elemento.files[0]);

      $.ajax({
        url: "../gestor/gestao/includes/create/documento.inc.php",
        type: "post",
        data: form_data,
        cache: false,
        contentType: false,
        processData: false,
        success: function(data) {
          //console.log("Sucesso: ", data);
          createZip(data, idCliente, codigo);
        }
      });
    }

    function documento(idCliente, codigo) {
      var elemento = document.querySelectorAll(".custom-file input");
      executar(elemento, idCliente, codigo);
    }
  </script>
  <?php if (isset($_GET["processo"])) {
  ?>
    <script>
      $(document).on("click", "#btn-submit", function(e) {
        e.preventDefault();
        let condicao1 = false;
        let condicao2 = false;
        let inputs = document.querySelectorAll("input.form-control:not([disabled])");
        let documentos = document.querySelectorAll(".custom-file-input:not([disabled])");
        for (let i = 0; i < inputs.length; i++) {
          if (inputs[i].value != '') {
            $.ajax({
              url: "../gestor/gestao/includes/update/inputUpdate.inc.php",
              type: "post",
              dataType: "json",
              data: {
                idCliente: idClienteActualizar,
                campo: inputs[i].id,
                valor: inputs[i].value
              },
              success: function(data) {
                condicao1 = true;
                console.log("Deu: ", data);
                /*Swal.fire({
                  title: 'A salvar alterações.',
                  html: '<div class="loading-point"><span></span><span></span><span></span></div>',
                  allowOutsideClick: false,
                  confirmButtonText: 'Aguarde',
                  confirmButtonColor: "#55127c",
                  icon: 'info'
                });*/
              },
              error: function(data) {
                /*Swal.fire({
                  title: 'Erro ao efectuar Alterações!',
                  text: 'Empresa: ' + nomeEmpresa.value,
                  confirmButtonText: 'Confirmar',
                  confirmButtonColor: "#55127c",
                  icon: 'error'
                });*/
              }

            }).done(() => {});
          }
        }

        for (let i = 0; i < documentos.length; i++) {
          if (documentos[i].files.length > 0) {
            let form_data = new FormData();
            form_data.append('id', idClienteActualizar);
            form_data.append('nomeDocumento', documentos[i].parentElement.parentElement.parentElement.querySelectorAll("small")[0].innerText.split(' (')[0]);
            form_data.append('nif', nifClienteActualizar);
            form_data.append('nomeEmpresa', nomeEmpresaActualizar);
            form_data.append('ficheiro', documentos[i].files[0]);

            $.ajax({
              url: "../gestor/gestao/includes/update/documento.inc.php",
              type: "post",
              data: form_data,
              cache: false,
              contentType: false,
              processData: false,
              success: function(data) {
                condicao2 = true;
                console.log("Acho que deu: ", data);
                createZip(data, idClienteActualizar, codigoActualizar);
                $.ajax({
                    url: "../gestor/gestao/includes/update/estadoProcesso.inc.php",
                    type: "post",
                    data: {
                        id: idClienteActualizar,
                        estado: 0
                    },
                    success: function(data) {
                      console.log(data);
                    }
                });
              }
            }).done(function() {
              if (condicao1 == true && condicao2 == true) {
                Swal.fire({
                  title: 'Obrigado, informações actualizadas com sucesso!',
                  text: 'Informações foram enviadas ao e-mail: ' + email.value + '.',
                  allowOutsideClick: false,
                  confirmButtonText: 'Confirmar',
                  confirmButtonColor: "#55127c",
                  icon: 'success'
                });
              }
            });
          }
        }
      });
    </script>
    <?php
    if (isset($_GET["Nome_da_Empresa"])) {
    ?>
      <script>
        nomeEmpresa.removeAttribute("disabled");
      </script>
    <?php
    }
    if (isset($_GET["NIF_da_Empresa"])) {
    ?>
      <script>
        nif.removeAttribute("disabled");
      </script>
    <?php
    }
    if (isset($_GET["Telefone_para_contacto"])) {
    ?>
      <script>
        telefone.removeAttribute("disabled");
      </script>
    <?php
    }
    if (isset($_GET["Telefone_para_contacto_Alternativo"])) {
    ?>
      <script>
        telefoneAlternativo.removeAttribute("disabled");
      </script>
    <?php
    }
    if (isset($_GET["Nome_da_pessoa_de_contacto"])) {
    ?>
      <script>
        nomePessoaContacto.removeAttribute("disabled");
      </script>
    <?php
    }
    if (isset($_GET["E-mail_para_contacto"])) {
    ?>
      <script>
        email.removeAttribute("disabled");
      </script>
    <?php
    }
    if (isset($_GET["Alvara_Comercial"])) {
    ?>
      <script>
        alvara.removeAttribute("disabled");
      </script>
    <?php
    }
    if (isset($_GET["Diario_da_Republica"])) {
    ?>
      <script>
        diario.removeAttribute("disabled");
      </script>
    <?php
    }
    if (isset($_GET["NIF_AGT"])) {
    ?>
      <script>
        nifAgt.removeAttribute("disabled");
      </script>
    <?php
    }
    if (isset($_GET["Responsavel_da_empresa"])) {
    ?>
      <script>
        responsavelDoc.removeAttribute("disabled");
      </script>
    <?php
    }
    if (isset($_GET["Certidao_Comercial"])) {
    ?>
      <script>
        certidao.removeAttribute("disabled");
      </script>
    <?php
    }
    if (isset($_GET["Procuracao"])) {
    ?>
      <script>
        procuracao.removeAttribute("disabled");
      </script>
    <?php
    }
    ?>
    <script>
      $.ajax({
        url: "../gestor/gestao/includes/read/queryProcesso.inc.php",
        type: "post",
        dataType: "json",
        data: {
          processo: "<?php echo $_GET["processo"]; ?>"
        },
        success: function(data) {
          idClienteActualizar = data[0]["idCliente"];
          nifClienteActualizar = data[0]["nif"];
          nomeEmpresaActualizar = data[0]["nomeEmpresa"];
          codigoActualizar = data[0]["codigo"];
          nomeEmpresa.value = data[0]["nomeEmpresa"];
          nif.value = data[0]["nif"];
          telefone.value = data[0]["telefone"];
          telefoneAlternativo.value = data[0]["telefoneAlternativo"];
          nomePessoaContacto.value = data[0]["nomePessoaContacto"];
          email.value = data[0]["email"];
          console.log("Esses são os dados: ", data)
        }
      });
    </script>
  <?php } else { ?>
    <script>
      $(document).on("click", "#btn-submit", function(e) {
        if (nif.value != '' && !nif.classList.contains("is-invalid") && nomeEmpresa.value != 0 && !nomeEmpresa.classList.contains("is-invalid") && telefone.value != '' && !telefone.classList.contains("is-invalid") && telefoneAlternativo.value != '' && !telefoneAlternativo.classList.contains("is-invalid") && nomePessoaContacto.value != '' && !nomePessoaContacto.classList.contains("is-invalid") && email.value != '' && !email.classList.contains("is-invalid") && alvara.value != '' && !alvara.classList.contains("is-invalid") && diario.value != '' && !diario.classList.contains("is-invalid") && nifAgt.value != '' && !nifAgt.classList.contains("is-invalid") && responsavelDoc.value != '' && !responsavelDoc.classList.contains("is-invalid") && certidao.value != '' && !certidao.classList.contains("is-invalid") && !procuracao.classList.contains("is-invalid")) {
          if (opAcucar50.checked || opAcucar1.checked || opAlcool.checked || opLab.checked || opOutro.checked && outro.value != "") {
            $.ajax({
              url: "../gestor/gestao/includes/create/cliente.inc.php",
              type: "post",
              dataType: "json",
              data: {
                nif: nif.value,
                nomeEmpresa: nomeEmpresa.value,
                telefone: telefone.value.split(' ')[1].replace(/\-/g, ''),
                telefoneAlternativo: telefoneAlternativo.value.split(' ')[1].replace(/\-/g, ''),
                nomePessoaContacto: nomePessoaContacto.value,
                email: email.value.replace(/\ /g, ''),
                opAcucar50: opAcucar50.value,
                opAcucar1: opAcucar1.value,
                opAlcool: opAlcool.value,
                opLab: opLab.value,
                outro: outro.value
              },
              success: function(data) {
                console.log("id: ", data[0]);
                console.log("codigo: ", data[1]);
                $.ajax({
                  url: "../gestor/gestao/includes/read/queryCliente.inc.php",
                  type: "post",
                  dataType: "json",
                  data: {
                    idCliente: data[0]
                  },
                  success: function(data) {
                    console.log("Resultado: ", data);
                    idClienteConfirm = data[0]["idCliente"];
                    emailConfirm = data[0]["email"];
                    telefoneConfirm = data[0]["telefone"];
                    nifConfirm = data[0]["nif"];
                    nomeEmpresaConfirm = data[0]["nomeEmpresa"];
                  }
                });
                documento(data[0], data[1]);
                Swal.fire({
                  title: 'O seu pedido está a ser enviado!',
                  html: '<div class="loading-point"><span></span><span></span><span></span></div>',
                  allowOutsideClick: false,
                  confirmButtonText: 'Aguarde',
                  confirmButtonColor: "#55127c",
                  icon: 'info'
                });

              },
              error: function(data) {
                Swal.fire({
                  title: 'Erro ao efectuar Cadastro!',
                  text: 'Empresa: ' + nomeEmpresa.value,
                  confirmButtonText: 'Confirmar',
                  confirmButtonColor: "#55127c",
                  icon: 'error'
                });
              }
            }).done(function(data) {
              console.log(data);
              let botao = document.querySelector(".swal2-confirm");
              botao.setAttribute('disabled', 'disabled');
            });
          } else {
            Swal.fire({
              title: 'Selecione um ou mais productos!',
              text: 'Tem que selecionar um ou mais productos da Biocom que tenciona adquirir para poder finalizar o registo.',
              confirmButtonText: 'Confirmar',
              confirmButtonColor: "#55127c",
              icon: 'warning'
            });
          }
        }
      });
    </script>
    <script src="../gestor/js/biocom.js"></script>
  <?php } ?>
</body>

</html>