const prazoPagamento = document.getElementById("prazoPagamento");
const entidade = document.getElementById("entidade");
const nomeEntidade = document.getElementById("nomeEntidade");
const nifEntidade = document.getElementById("nifEntidade");
const entregueSpan = document.getElementById("entregueSpan");
const totalSpan = document.getElementById("totalSpan");
const totalEntregue = document.getElementById("totalEntregue");

const slidePage = document.querySelector(".slidePage");
const firstNextBtn = document.querySelector(".nextBtn");
const prevBtnSec = document.querySelector(".prev-1");
const nextBtnSec = document.querySelector(".next-1");
const prevBtnThird = document.querySelector(".prev-2");
const submitBtn = document.querySelector(".submit");
const progressText = document.querySelectorAll(".step p");
const progressCheck = document.querySelectorAll(".step .check");
const bullet = document.querySelectorAll(".step .bullet");

const footerPagamento = document.getElementById("footerPagamento");

let numberRegExp = new RegExp('^[0-9-()-+ ]+$');
let letterRegExp = new RegExp('^[a-zA-Z ]+$');
let biRegExp = new RegExp('^[a-zA-Z0-9]+$');
let emailRegExp = new RegExp('^[A-Za-z0-9._-]{3,}@[A-Za-z._-]{3,}[.]{1}[A-Za-z.]{2,6}$');

let max = 3;
let current = 1;

firstNextBtn.addEventListener("click", function (e) {
    e.preventDefault();
    console.log(idEntidade);
    if (idEntidade != undefined && nomeEntidade.value != '' && nifEntidade.value != '' && prazoPagamento.value != 0 && entidade.value != 0) {
        slidePage.style.marginLeft = "-25%";
        bullet[current - 1].classList.add("active");
        progressText[current - 1].classList.add("active");
        progressCheck[current - 1].classList.add("active");
        current += 1;
        footerPagamento.style.opacity = 1;
        $('#tabelaArtigo').DataTable().clear().draw();
        addRow();
        totalText.innerText = "TOTAL";
        totalText.className = "text-danger";
        totalSpan.className = "";
        totalDocumento();
    } else {
        let smallEntidade = entidade.parentElement.parentElement.querySelectorAll("small")[1];
        let smallPrazoPagamento = prazoPagamento.parentElement.querySelectorAll("small")[1];
        if (idEntidade == undefined || entidade.value == "") {
            entidade.className = "form-control is-invalid";
            smallEntidade.style.visibility = "visible";
            smallEntidade.style.color = "#dc3545";
            smallEntidade.innerText = "Selecione a Entidade e precione a tecla enter!";
        } else {
            smallEntidade.style.visibility = "hidden";
        }

        if ($("#prazoPagamento").val() == 0) {
            prazoPagamentoInvalid(smallPrazoPagamento);
        } else {
            prazoPagamentoValid(smallPrazoPagamento);
        }
    }
});

nextBtnSec.addEventListener("click", function (e) {
    e.preventDefault();
    let bool = true;
    let tabela = document.getElementById("tabelaArtigo");
    for (i = 1; i < tabela.rows.length; i++) {
        if (tabela.rows[i].querySelector(".inputSearchArtigo").value != '') {
            let precoInput = tabela.rows[i].querySelector(".preco");
            let precoValue = parseFloat(precoInput.value.replace(",", "."));
            if (isNaN(precoValue) || precoValue <= 0) {
                bool = false;
                break;
            }
        }
    }

    if (bool == true && totalSpan.innerText != "0,00 Kzs") {
        slidePage.style.marginLeft = "-50%";
        bullet[current - 1].classList.add("active");
        progressText[current - 1].classList.add("active");
        progressCheck[current - 1].classList.add("active");
        current += 1;
        footerPagamento.style.opacity = 1;
    } else {
        // Pelo menos um valor na coluna "preco" é inválido ou menor ou igual a zero.
        // Faça algo aqui se necessário.
    }
});

submitBtn.addEventListener("click", function (e) {
    e.preventDefault();
    bullet[current - 1].classList.add("active");
    progressText[current - 1].classList.add("active");
    progressCheck[current - 1].classList.add("active");
    current += 1;
    createDocumento();
});

prevBtnSec.addEventListener("click", function (e) {
    e.preventDefault();
    slidePage.style.marginLeft = "0%";
    bullet[current - 2].classList.remove("active");
    progressText[current - 2].classList.remove("active");
    progressCheck[current - 2].classList.remove("active");
    current -= 1;
    footerPagamento.style.opacity = 0;
});

prevBtnThird.addEventListener("click", function (e) {
    e.preventDefault();
    slidePage.style.marginLeft = "-25%";
    bullet[current - 2].classList.remove("active");
    progressText[current - 2].classList.remove("active");
    progressCheck[current - 2].classList.remove("active");
    current -= 1;
});

function prazoPagamentoInvalid(small) {
    prazoPagamento.classList.add("select2-danger");
    prazoPagamento.setAttribute('data-dropdown-css-class', 'select2-danger');
    small.style.visibility = "visible";
    small.style.color = "#dc3545";
    small.innerText = "Selecione um Prazo de Pagamento!";
    firstNextBtn.setAttribute('disabled', 'disabled');
}

function prazoPagamentoValid(small) {
    prazoPagamento.classList.remove("select2-danger");
    prazoPagamento.classList.add("is-valid");
    prazoPagamento.style.borderColor = "#ffc107";
    firstNextBtn.removeAttribute('disabled');
    small.style.visibility = "hidden";
}

$('#prazoPagamento').select2().on('change', function () {
    let small = prazoPagamento.parentElement.querySelectorAll("small")[1];
    if ($("#prazoPagamento").val() == 0) {
        prazoPagamentoInvalid(small);
    } else {
        prazoPagamentoValid(small);
    }
});

function resetForm() {
    slidePage.style.marginLeft = "0%";
    for (let i = 0; i < progressText.length; i++) {
        bullet[i].classList.remove("active");
        progressText[i].classList.remove("active");
        progressCheck[i].classList.remove("active");
    }
    current = 1;
}